/**
 ** PHPIXROW.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "p16.h"
#include "memfill.h"

void _GrPHSetPixRow(long addr,int color,int width)
{
	pixptr p = P_ADDRESS(CURC,addr);
	int oper = C_OPER(color);

	if(width <= 0) return;
	if((_GrPHDrawTable[oper] ^ (color &= C_SIGNIF)) == 0) return;
	_ClrDir();
	switch(oper) {
	    case C_XOR: _RowSetXorW(XW,p,color,width); return;
	    case C_OR:  _RowSetOrW(OW,p,color,width);  return;
	    case C_AND: _RowSetAndW(AW,p,color,width); return;
	    default:	_RowSetW(WW,p,color,width);    return;
	}
}

