/**
 ** P4.H
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#ifdef __TURBOC__
# pragma  inline
#endif

#include "grx.h"
#include "libgrx.h"
#include "vgaregs.h"

#ifdef __TURBOC__
  typedef unsigned char far *pixptr;
#endif

#ifdef __GNUC__
  typedef unsigned char volatile *pixptr;
#endif

#define C_SIGNIF	    0x0f	/* significant bits in a color */

#define P_OFFSET(off)	    ((int)(off) & 0x07)
#define P_XPOS(off)	    (((unsigned)COORD_X(off)) >> 3)
#define P_ADDRESS(cxt,off)  ((pixptr)((cxt)->gc_baseaddr +		\
    (unsigned)(COORD_Y(off) * (cxt)->gc_lineoffset) +			\
    P_XPOS(off)								\
))

extern int  _GrP4ModeReg;		/* saved bits of mode register */
extern int  _GrP4WriteOps[4];		/* VGA write ops (Set, Xor...) */
extern int  _GrP4DrawTable[4];		/* drawing enable table */


/*
 * compute left and right masks for fills and bitblt
 */
#define _ComputeMasks(adr,wdt,lmsk,rmsk) do {				\
    register int _temp_;						\
    lmsk = rmsk = 0;							\
    if((_temp_ = P_OFFSET((int)adr + wdt)) != 0) {			\
	wdt -= _temp_;							\
	rmsk = (unsigned char)(0xff00 >> _temp_);			\
    }									\
    if((_temp_ = P_OFFSET(adr)) != 0) {					\
	wdt -= (8 - _temp_);						\
	lmsk = (0xff >> _temp_);					\
    }									\
    if((wdt >>= 3) < 0) {						\
	lmsk &= rmsk;							\
	rmsk = 0;							\
	wdt  = 0;							\
    }									\
} while(0)

/*
 * left and right mask bytes in an integer...
 */
#define L_MASK(_word_)	    (((unsigned char *)(&(_word_)))[0])
#define R_MASK(_word_)	    (((unsigned char *)(&(_word_)))[1])
#define _ComputeMaskWord(addr,wdt,mword) do {				\
    _ComputeMasks(addr,wdt,L_MASK(mword),R_MASK(mword))			\
} while(0)

#ifdef  __GNUC__
#define _GetVGAModeMask() do {						\
    if(_GrAdapterType == GR_VGA) asm volatile(			     "\n\
	movl	$L_VGA_GR_CTRL_PORT,%%edx			      \n\
	movb	$L_VGA_MODE_REG,%%al				      \n\
	outb	%%al,%%dx					      \n\
	incl	%%edx						      \n\
	inb	%%dx,%%al					      \n\
	movb	%%al,%%ah					      \n\
	andb	$0xfc,%%ah					      \n\
	movb	$L_VGA_MODE_REG,%%al				      \n\
	movl	%%eax,%0					       "\
	: "=g" (_GrP4ModeReg)						\
	: /* NOTHING */							\
	: "dx", "ax"							\
    );									\
    else { /* EGA */							\
	_GrP4ModeReg = VGA_MODE_REG;					\
    }									\
} while(0)
#endif

#ifdef  __TURBOC__
#define _GetVGAModeMask() do {						\
    if(_GrAdapterType == GR_VGA) {					\
	asm mov	    dx,VGA_GR_CTRL_PORT;				\
	asm mov	    al,VGA_MODE_REG;					\
	asm out	    dx,al;						\
	asm inc	    dx;							\
	asm in	    al,dx;						\
	_GrP4ModeReg = ((_AX & 0xfc) << 8) | VGA_MODE_REG;		\
    }									\
    else { /* EGA */							\
	_GrP4ModeReg = VGA_MODE_REG;					\
    }									\
} while(0)
#endif

