/** 
 ** MEMFILL.H 
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#ifndef _MEMFILL_H_
#define _MEMFILL_H_

#ifdef  __TURBOC__
#pragma inline
#endif

/*
 * utilities -- other files may define them too
 */
#ifndef _SaveDS

#ifdef  __TURBOC__
#define _ClrDir()	asm cld
#define _SetDir()	asm std
#define _SaveDS()	asm push    ds
#define _RestoreDS()	asm pop	    ds
#endif

#ifdef  __GNUC__
#define _ASV		asm volatile
#define _ClrDir()	_ASV("cld")
#define _SetDir()	_ASV("std")
#define _SaveDS()
#define _RestoreDS()
#endif

#endif  /* _SaveDS */

/*
 * set a pixel row
 */
#ifdef  __TURBOC__
#define _MF_ROWSET_(addr,data,len,SZ) do {				    \
	_CX = len;							    \
	_AX = data;							    \
	asm les	    di,DWORD PTR addr;					    \
	asm rep	    stos##SZ;						    \
} while(0)
#endif

#ifdef  __GNUC__
#define _MF_ROWSET_(addr,data,len,SZ) _ASV(				 "\n\
	movl	%0,%%edi						  \n\
	movl	%1,%%eax						  \n\
	movl	%2,%%ecx						  \n\
	rep								  \n\
	stos"#SZ"							   "\
	: /* NOTHING */							    \
	: "g" (addr), "g" (data), "g" (len)				    \
	: "di", "cx", "ax"						    \
)
#endif

#define _RowSetB(ID,addr,data,len)	_MF_ROWSET_(addr,data,len,b)
#define _RowSetW(ID,addr,data,len)	_MF_ROWSET_(addr,data,len,w)
#define _RowSetL(ID,addr,data,len)	_MF_ROWSET_(addr,data,len,l)

/*
 * set a pixel row with logical operations
 */
#ifdef  __TURBOC__
#define _MF_ROWSETOPR_(addr,data,len,OPR,REG,SZ,ID) do {		    \
	_CX = len;							    \
	_DX = data;							    \
	asm les	    di,DWORD PTR addr;					    \
MF_RowSet##ID##Loop:							    \
	asm mov	    ax,dx;						    \
	asm OPR	    REG,es:[di];					    \
	asm stos##SZ;							    \
	asm loop    MF_RowSet##ID##Loop;				    \
} while(0)
#endif

#ifdef  __GNUC__
#define _MF_ROWSETOPR_(addr,data,len,OPR,REG,SZ,ID) _ASV(		 "\n\
	movl	%0,%%edi						  \n\
	movl	%1,%%edx						  \n\
	movl	%2,%%ecx						  \n\
L_MF_RowSet"#ID"Loop:							  \n\
	movl	%%edx,%%eax						  \n\
	"#OPR #SZ"  (%%edi),%%"#REG"					  \n\
	stos"#SZ"							  \n\
	loop	L_MF_RowSet"#ID"Loop					   "\
	: /* NOTHING */							    \
	: "g" (addr), "g" (data), "g" (len)				    \
	: "di", "dx", "cx", "ax"					    \
)
#endif

#define _RowSetXorB(ID,addr,data,len)	_MF_ROWSETOPR_(addr,data,len,xor,al,b,ID##XB)
#define _RowSetOrB(ID,addr,data,len)	_MF_ROWSETOPR_(addr,data,len,or,al,b,ID##OB)
#define _RowSetAndB(ID,addr,data,len)	_MF_ROWSETOPR_(addr,data,len,and,al,b,ID##AB)

#define _RowSetXorW(ID,addr,data,len)	_MF_ROWSETOPR_(addr,data,len,xor,ax,w,ID##XW)
#define _RowSetOrW(ID,addr,data,len)	_MF_ROWSETOPR_(addr,data,len,or,ax,w,ID##OW)
#define _RowSetAndW(ID,addr,data,len)	_MF_ROWSETOPR_(addr,data,len,and,ax,w,ID##AW)

#define _RowSetXorL(ID,addr,data,len)	_MF_ROWSETOPR_(addr,data,len,xor,eax,l,ID##XL)
#define _RowSetOrL(ID,addr,data,len)	_MF_ROWSETOPR_(addr,data,len,or,eax,l,ID##OL)
#define _RowSetAndL(ID,addr,data,len)	_MF_ROWSETOPR_(addr,data,len,and,eax,l,ID##AL)

/*
 * set a pixel column with logical operations
 */
#ifdef  __TURBOC__
#define _MF_COLSETOPR_(addr,offs,data,hgt,OPR,REG,SZ,ID) do {		    \
	_DX = offs;							    \
	_CX = hgt;							    \
	_AX = data;							    \
	asm les	    di,DWORD PTR addr;					    \
MF_ColSet##ID##Loop:							    \
	asm OPR	    es:[di],REG;					    \
	asm add	    di,dx;						    \
	asm loop    MF_ColSet##ID##Loop;				    \
} while(0)
#endif

#ifdef  __GNUC__
#define _MF_COLSETOPR_(addr,offs,data,hgt,OPR,REG,SZ,ID) _ASV(		 "\n\
	movl	%0,%%edi						  \n\
	movl	%1,%%edx						  \n\
	movl	%2,%%eax						  \n\
	movl	%3,%%ecx						  \n\
L_MF_ColSet"#ID"Loop:							  \n\
	"#OPR #SZ"  %%"#REG",(%%edi)					  \n\
	addl	%%edx,%%edi						  \n\
	loop	L_MF_ColSet"#ID"Loop					   "\
	: /* NOTHING */							    \
	: "g" (addr), "g" (offs), "g" (data), "g" (hgt)			    \
	: "di", "dx", "cx", "ax"					    \
)
#endif

#define _ColSetB(ID,adr,ofs,dta,h)	_MF_COLSETOPR_(adr,ofs,dta,h,mov,al,b,ID##B)
#define _ColSetXorB(ID,adr,ofs,dta,h)	_MF_COLSETOPR_(adr,ofs,dta,h,xor,al,b,ID##XB)
#define _ColSetOrB(ID,adr,ofs,dta,h)	_MF_COLSETOPR_(adr,ofs,dta,h,or,al,b,ID##OB)
#define _ColSetAndB(ID,adr,ofs,dta,h)	_MF_COLSETOPR_(adr,ofs,dta,h,and,al,b,ID##AB)

#define _ColSetW(ID,adr,ofs,dta,h)	_MF_COLSETOPR_(adr,ofs,dta,h,mov,ax,w,ID##W)
#define _ColSetXorW(ID,adr,ofs,dta,h)	_MF_COLSETOPR_(adr,ofs,dta,h,xor,ax,w,ID##XW)
#define _ColSetOrW(ID,adr,ofs,dta,h)	_MF_COLSETOPR_(adr,ofs,dta,h,or,ax,w,ID##OW)
#define _ColSetAndW(ID,adr,ofs,dta,h)	_MF_COLSETOPR_(adr,ofs,dta,h,and,ax,w,ID##AW)

#define _ColSetL(ID,adr,ofs,dta,h)	_MF_COLSETOPR_(adr,ofs,dta,h,mov,eax,l,ID##L)
#define _ColSetXorL(ID,adr,ofs,dta,h)	_MF_COLSETOPR_(adr,ofs,dta,h,xor,eax,l,ID##XL)
#define _ColSetOrL(ID,adr,ofs,dta,h)	_MF_COLSETOPR_(adr,ofs,dta,h,or,eax,l,ID##OL)
#define _ColSetAndL(ID,adr,ofs,dta,h)	_MF_COLSETOPR_(adr,ofs,dta,h,and,eax,l,ID##AL)

/*
 * set a pixel block
 */
#ifdef  __TURBOC__
#define _MF_BLKSET_(addr,offs,data,wdt,hgt,SZ,ID) do {			    \
	_DX = offs;							    \
	_BX = hgt;							    \
	_AX = data;							    \
	asm les	    di,DWORD PTR addr;					    \
MF_BlkSet##ID##Loop:							    \
	asm mov	    cx,WORD  PTR wdt;					    \
	asm rep	    stos##SZ;						    \
	asm add	    di,dx;						    \
	asm dec	    bx;							    \
	asm jnz	    MF_BlkSet##ID##Loop;				    \
} while(0)
#endif

#ifdef  __GNUC__
#define _MF_BLKSET_(addr,offs,data,wdt,hgt,SZ,ID) _ASV(			 "\n\
	movl	%0,%%edi						  \n\
	movl	%1,%%edx						  \n\
	movl	%2,%%eax						  \n\
	movl	%4,%%ebx						  \n\
L_MF_BlkSet"#ID"Loop:							  \n\
	movl	%3,%%ecx						  \n\
	rep								  \n\
	stos"#SZ"							  \n\
	addl	%%edx,%%edi						  \n\
	decl	%%ebx							  \n\
	jnz	L_MF_BlkSet"#ID"Loop					   "\
	: /* NOTHING */							    \
	: "g" (addr), "g" (offs), "g" (data), "g" (wdt), "g" (hgt)	    \
	: "di", "dx", "cx", "bx", "ax"					    \
)
#endif

#define _BlkSetB(ID,adr,ofs,dta,wd,hg)  _MF_BLKSET_(adr,ofs,dta,wd,hg,b,ID##B)
#define _BlkSetW(ID,adr,ofs,dta,wd,hg)  _MF_BLKSET_(adr,ofs,dta,wd,hg,w,ID##W)
#define _BlkSetL(ID,adr,ofs,dta,wd,hg)  _MF_BLKSET_(adr,ofs,dta,wd,hg,l,ID##L)

/*
 * set a pixel block with logical operations
 */
#ifdef  __TURBOC__
#define _MF_BLKSETOPR_(addr,offs,data,wdt,hgt,OPR,REG,SZ,ID) do {	    \
	_SI = offs;							    \
	_BX = hgt;							    \
	_DX = data;							    \
	asm les	    di,DWORD PTR addr;					    \
MF_BlkSet##ID##VertLoop:						    \
	asm mov	    cx,WORD  PTR wdt;					    \
MF_BlkSet##ID##LineLoop:						    \
	asm mov	    ax,dx;						    \
	asm OPR	    REG,es:[di];					    \
	asm stos##SZ;							    \
	asm loop    MF_BlkSet##ID##LineLoop;				    \
	asm add	    di,si;						    \
	asm dec	    bx;							    \
	asm jnz	    MF_BlkSet##ID##VertLoop;				    \
} while(0)
#endif

#ifdef  __GNUC__
#define _MF_BLKSETOPR_(addr,offs,data,wdt,hgt,OPR,REG,SZ,ID) _ASV(	 "\n\
	movl	%0,%%edi						  \n\
	movl	%2,%%edx						  \n\
	movl	%4,%%ebx						  \n\
L_MF_BlkSet"#ID"VertLoop:						  \n\
	movl	%3,%%ecx						  \n\
L_MF_BlkSet"#ID"LineLoop:						  \n\
	movl	%%edx,%%eax						  \n\
	"#OPR #SZ"  (%%edi),%%"#REG"					  \n\
	stos"#SZ"							  \n\
	loop	L_MF_BlkSet"#ID"LineLoop				  \n\
	addl	%1,%%edi						  \n\
	decl	%%ebx							  \n\
	jne	L_MF_BlkSet"#ID"VertLoop				   "\
	: /* NOTHING */							    \
	: "g" (addr), "g" (offs), "g" (data), "g" (wdt), "g" (hgt)	    \
	: "di", "dx", "cx", "bx", "ax"					    \
)
#endif

#define _BlkSetXorB(ID,adr,ofs,dta,w,h) _MF_BLKSETOPR_(adr,ofs,dta,w,h,xor,al,b,ID##XB)
#define _BlkSetOrB(ID,adr,ofs,dta,w,h)  _MF_BLKSETOPR_(adr,ofs,dta,w,h,or,al,b,ID##OB)
#define _BlkSetAndB(ID,adr,ofs,dta,w,h) _MF_BLKSETOPR_(adr,ofs,dta,w,h,and,al,b,ID##AB)

#define _BlkSetXorW(ID,adr,ofs,dta,w,h) _MF_BLKSETOPR_(adr,ofs,dta,w,h,xor,ax,w,ID##XW)
#define _BlkSetOrW(ID,adr,ofs,dta,w,h)  _MF_BLKSETOPR_(adr,ofs,dta,w,h,or,ax,w,ID##OW)
#define _BlkSetAndW(ID,adr,ofs,dta,w,h) _MF_BLKSETOPR_(adr,ofs,dta,w,h,and,ax,w,ID##AW)

#define _BlkSetXorL(ID,adr,ofs,dta,w,h) _MF_BLKSETOPR_(adr,ofs,dta,w,h,xor,eax,l,ID##XL)
#define _BlkSetOrL(ID,adr,ofs,dta,w,h)  _MF_BLKSETOPR_(adr,ofs,dta,w,h,or,eax,l,ID##OL)
#define _BlkSetAndL(ID,adr,ofs,dta,w,h) _MF_BLKSETOPR_(adr,ofs,dta,w,h,and,eax,l,ID##AL)

#endif  /* whole file */

