/**
 ** CIRCLE.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"

void GrEllipse(int xc,int yc,int xa,int ya,int c)
{
	_GrScanEllipse(xc,yc,xa,ya,
	    FALSE,
	    IS_XOR_COLOR(c),
	    _GrDrawSolidPixel,
	    _GrDrawSolidLine,
	    _GrFillSolidScanLine,
	    &c
	);
}

void GrEllipseArc(int xc,int yc,int xa,int ya,int start,int end,int c)
{
	int points[MAX_ELLIPSE_PTS+1][2];
	int numpts = _GrGenerateEllipseArc(points,xc,yc,xa,ya,start,end,FALSE);

	_GrDrawPolygon(IABS(numpts),points,
	    (numpts < 0),
	    IS_XOR_COLOR(c),
	    _GrDrawSolidPixel,
	    _GrDrawSolidLine,
	    &c
	);
}

void GrCircle(int xc,int yc,int r,int c)
{
	GrEllipse(xc,yc,r,r,c);
}

void GrCircleArc(int xc,int yc,int r,int start,int end,int c)
{
	GrEllipseArc(xc,yc,r,r,start,end,c);
}

