/** 
 ** GRXFONT.H 
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#ifndef _GRXFONT_H_
#define _GRXFONT_H_

#if defined(__GNUC__) && !defined(near)
# define near
# define far
# define huge
#endif

typedef struct {			/* fixed font structure */
    GrFont  h;				/* font header */
    short   ff_chrsize;			/* size of a character in bytes */
    char    far *ff_bits;		/* fixed font bitmap */
} FixedFont;

typedef struct {			/* proportional font structure */
    GrFont  h;				/* font header */
    short   pf_minwidth;		/* smallest font width */
    short   pf_maxwidth;		/* largest font width */
    short  *pf_width;			/* ptr to array of character widths */
    char    far *pf_bits[1];		/* fixed font bitmap */
} PropFont;

extern GrFont *_GrDefaultFont;

extern GrFont *_GrGetDefaultFont(void);
extern int _GrGetTextSize(char *txt,int len,int *w,int *h,GrTextOption *opt);

#define CHECK_FONT(font)						\
    (((font) != NULL) ?							\
	(font) :							\
	(_GrDefaultFont != NULL) ? _GrDefaultFont : _GrGetDefaultFont())


#define FFP(f)  ((FixedFont *)(f))
#define PFP(f)  ((PropFont  *)(f))


#endif /* whole file */

