#include "fntool.h"
#include "../include/grx.h"
#include "../include/grxfile.h"

static void badfnt(void)
{
	fatalerr("invalid \".fnt\" file: \"%s\"",inname);
}

static void readdata(void *buffer,int size)
{
	if(read(fileno(infile),buffer,size) != size) badfnt();
}

void readfnt(void)
{
	FntFileHdr hdr;
	short *wtable = NULL;
	char  *bitmap,*bp;
	chr   *cp,*last;
	int   ii,xx,yy,mask,byte,width;

	readdata(&hdr,sizeof(FntFileHdr));
	if(hdr.magic != FONT_MAGIC) badfnt();
	if(!hdr.h.fnt_isfixed) {
	    ii = (hdr.h.fnt_maxchar - hdr.h.fnt_minchar + 1) * sizeof(short);
	    readdata((wtable = safemalloc(ii)),ii);
	}
	bitmap = safemalloc(hdr.bitmapsize);
	readdata(bitmap,hdr.bitmapsize);
	for(bp = notes; (ii = getc(infile)) != EOF; *bp++ = ii);
	*bp = '\0';
	fnt.height  = hdr.h.fnt_height;
	fnt.minchar = hdr.h.fnt_minchar;
	fnt.maxchar = hdr.h.fnt_maxchar;
	fnt.isfixed = hdr.h.fnt_isfixed;
	strcpy(fnt.name,hdr.h.fnt_name);
	strcpy(fnt.family,hdr.h.fnt_family);
	last = NULL;
	bp = bitmap;
	for(ii = fnt.minchar; ii <= fnt.maxchar; ii++) {
	    width = fnt.isfixed ? hdr.h.fnt_width : wtable[ii - fnt.minchar];
	    cp = safemalloc(sizeof(chr));
	    cp->bmp = makebytemap(width,fnt.height);
	    for(yy = 0; yy < fnt.height; yy++) {
		byte = mask = 0;
		for(xx = 0; xx < width; xx++) {
		    if((mask >>= 1) == 0) { byte = *bp++; mask = 0x80; }
		    cp->bmp[yy][xx] = (byte & mask) ? 1 : 0;
		}
	    }
	    cp->code  = ii;
	    cp->width = width;
	    *(last ? &last->next : &fnt.chars) = cp;
	    last = cp;
	}
	free(bitmap);
	if(!hdr.h.fnt_isfixed) free(wtable);
	computewidth();
	splitfamily();
	if((fnt.undwidth = hdr.h.fnt_undwidth) == 0) {
	    fnt.undwidth = (fnt.height / 20) + 1;
	}
	if((fnt.baseline = hdr.h.fnt_baseline) == 0) {
	    fnt.baseline = fnt.height - 1;
	    if((cp = getchr('a')) != NULL) {
		while((fnt.baseline > 0) && !rowbit(cp->bmp,fnt.baseline)) {
		    fnt.baseline--;
		}
	    }
	}
}

