/**********************************************************************
 *  
 *  NAME:           attrmap.h
 *  
 *  DESCRIPTION:    attribute mapping object
 *  
 *  copyright (c) 1990 J. Alan Eldridge
 * 
 *  M O D I F I C A T I O N   H I S T O R Y
 *
 *  when        who                 what
 *  -------------------------------------------------------------------
 *  11/25/90    J. Alan Eldridge    created
 *  
 *********************************************************************/

#ifndef __ATTRMAP_H
#define __ATTRMAP_H

class attribmap {

private:

    enum { MAPSIZE = 16 };
    uchar   map [ MAPSIZE ];

public:

    void    clearmap()
        { memset(map, vid_defaultatt, MAPSIZE); }
    attribmap()
        { clearmap(); }
    void    setmap(int val, int newval)
        { if (val < MAPSIZE) map[val] = newval; }
    void    setmap(uchar *newmap, int n = MAPSIZE)
        { clearmap(); memcpy(map, newmap, min(n,MAPSIZE)); }
    uchar   getmap(int n)
        { return n < MAPSIZE ? map[n] : vid_defaultatt; }
    void    getmap(uchar *pmap, int n = MAPSIZE)
        { memcpy(pmap, map, min(n,MAPSIZE)); }
    int     mapsize()
        { return MAPSIZE; }        
};

#endif
