/*
    sysqvfnc.h

    queues of objects of type Qable
    
    copyright (c) 1991 J. Alan Eldridge
    
    history:
    
    < from sysqtmpl.h -- the template version >

    10/28/91    created
    
    10/30/91    changed class hierarchy so we now have:
    
                SysQ<T>     queue of Ts
                SysPriQ<T>  priority queue of Ts
                SysQP<T>    queue of ptrs to T
                SysPriQP<T> priority queue of ptrs to T

    11/08/91    created this virtual function version...
                this has only classes SysQP and SysPriQP
*/

/*
    in the virtual function version of SysQ, anything that can
    be put on a queue must define operator <, so it can be put
    on a priority queue... <sorry, but without templates I've
    gotta impose rules>
*/    

class Qable {
private:
    //  nothing right now
public:
    virtual int operator<(Qable &) = 0;
};

struct SysQNode {
    Qable       *data;
    SysQNode    *next;
    SysQNode    *prev;
};
    
class SysQP {
protected:
    int         nused, nfree, maxnodes;
    SysQNode    *head, *tail, *free;

    SysQNode    *getfree(int=1);
    void        putfree(SysQNode*);

    SysQNode            *findnode(Qable*);
    virtual SysQNode    *findpred(Qable*);
    
    void        create(SysQNode*);
    void        insert(SysQNode*, SysQNode*);

    int         Ins(Qable*);
    int         Get(Qable* &,int rmv=1);
public:
    SysQP(int n=0, int lim=INT_MAX);
    virtual ~SysQP();
    int         Add(Qable*);
    int         Del(Qable*);
    Qable*      Get(int rmv=1);
    int         Cnt()
        { return nused; }
    int         Max()
        { return maxnodes; }
};

class SysPriQP: public SysQP {
public:
    SysPriQP(int n=0,int lim=INT_MAX): SysQP(n,lim)
        { }
    int Add(Qable *t)
        { return SysQP::Ins(t); }
};

