/*------------------------------------------------------------
 * 
 *  wdelch.c
 * 
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 *
 *  deletes a char at the cursor position in a window
 *  rightmost char on line is blanked
 * 
 *----------------------------------------------------------*/

#include "curses.h"

int
wdelch(win)
WINDOW *win;
{
    VIDCHR *ptr;
    int cury, curx, endcol;

    getyx(win, cury, curx);
    markwin(win);
    endcol = win->maxx;
    ptr = &(win->buf[cury][curx]);
    memcpy(ptr, ptr + 1, (endcol - curx) * sizeof(VIDCHR));
    wmove(win, cury, endcol);
    win->buf[cury][endcol].chr = ' ';
    win->buf[cury][endcol].att = win->attrib;
    markwin(win);
    wmove(win, cury, curx);

    return OK;
}

