/*----------------------------------------------------------------------
 * 
 *  line.c
 *
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 *
 *  there are 3 functions here
 *
 *  for all functions, n = 0 for single line and 1 for double line
 *
 *  linechar(h_or_v,n)
 *
 *      returns a horizontal (h_or_v==0) or vertical (h_or_v==1) line character
 *
 *  whline(win,n,len) 
 *
 *  wvline(win,n,len)
 *
 *      draws a line on the specified window, starting at the current
 *      cursor position, does not move the cursor, will not overflow
 *      the window
 *
 *----------------------------------------------------------------------
 */

#include "curses.h"

static UCHAR linechars[][2] = {
    196, 205, 179, 186
};

int
linechar(h_or_v, n)
int h_or_v, n;
{
    return linechars[h_or_v][n];
}

void
whline(win, n, len)
WINDOW  *win;
int     n, len;
{
    int y, x;

    getyx(win, y, x);
    if (len > getmaxc(win) - x + 1)
        len = getmaxc(win) - x + 1;
    while (len-- > 0)
        waddch(win, linechars[0][n]);
    wmove(win, y, x);
}

void
wvline(win, n, len)
WINDOW  *win;
int     n, len;
{
    int y1, y2, x;

    getyx(win, y1, x);
    if (len > getmaxr(win) - y1 + 1)
        len = getmaxr(win) - y1 + 1;
    y2 = y1;
    while (len-- > 0) {
        waddch(win, linechars[1][n]);
        wmove(win, ++y2, x);
    }
    wmove(win, y1, x);
}
