/*--------------------------------------------------------------------
 *
 *  drawbox.c
 *
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 *
 *  draws a box on win, with dimensions lines x cols, using v and h
 *  the box is drawn at the current cursor location
 *
 *  v and h are interpreted as desribed in box.c
 *  
 *--------------------------------------------------------------------
 */

#include "curses.h"

drawbox(win,lines,cols,v,h)
WINDOW *win;
{
  WINDOW *bwin,*subwin();

  bwin = subwin(win,lines,cols,win->orgy+win->cury,win->orgx+win->curx);
  if (!bwin)
    return ERR;
  box(bwin,v,h);
  delwin(bwin);
  return OK;
}
