/**********************************************************************
 * 
 * pcvideo.h
 * 
 * defines used by video functions
 * 
 * Copyright (c) 1988,89 J. Alan Eldridge
 * 
 *********************************************************************/

#ifndef __PCVIDEO__

#define __PCVIDEO__

/**********************************************************************
 * 
 *  physical screen size used by some low level functions
 *
 *********************************************************************/
    
#define VID_MAX_ROWS   25      /* size of physical screen */
#define VID_MAX_COLS   80      /* this is used to create curscr */

/**********************************************************************
 *  
 *  arrow characters in IBM graphics char set 
 *
 *********************************************************************/
    
#define CH_UPARROW  24
#define CH_DNARROW  25
#define CH_LFARROW  27
#define CH_RTARROW  26

/**********************************************************************
 *  
 *  defines for color video attributes
 *
 *********************************************************************/
    
#define VID_BLACK       0
#define VID_BLUE        1
#define VID_GREEN       2
#define VID_CYAN        3
#define VID_RED         4
#define VID_MAGENTA     5
#define VID_YELLOW      6
#define VID_WHITE       7

#define VID_BLINK       8
#define VID_BRIGHT      8

/**********************************************************************
 *  
 *  macro to create a video attribute from foreground, background colors
 *  
 *********************************************************************/

#define VID_ATTRIB(f,b) ((f) | ((b) << 4))

/**********************************************************************
 *  
 *  default attributes for Curses! windows
 *  
 *********************************************************************/

#define VID_DEFNORM     VID_ATTRIB(VID_WHITE,VID_BLACK)
#define VID_DEFSTAND    VID_ATTRIB(VID_BLACK,VID_WHITE)
#define VID_DEFBRIGHT   VID_ATTRIB(VID_WHITE|VID_BRIGHT,VID_BLACK)

/**********************************************************************
 *  
 *  constants for interfacing to video BIOS calls
 *  
 *********************************************************************/

#define VID_INTR            0x10    /* video BIOS interrupt # */

#define VB_SET_CURS_SIZE    0x01    /* "set cursor size" function # */
#define VB_SET_CURS_POSN    0x02    /* "set cursor position" function # */
#define VB_GET_CURS_INFO    0x03    /* "get cursor size & posn" function # */

#define VB_NO_CURSOR        0x2020  /* setting the starting & ending ... */
                                    /* scan lines to 32 disables the cursor */

#define VB_SCROLL_WIN_UP    0x06    /* "scroll window up" function # */

#define VB_WRITE_CHRATT_STR 0x13    /* AT function to write char/attr string */

#define VB_NOFIX_CURSOR     0x02    /* leave cursor at beginning of string */
#define VB_FIX_CURSOR       0x03    /* position cursor at end of string */

#define VB_WRITE_CHR_ATT    0x09    /* PC function to write 1 char/attr */

#define VB_GET_VID_MODE     0x0f    /* "get mode" function # */

#define VB_DISP_PAGE_0      0        /* DISP page to use (always 0) */

/**********************************************************************
 *  
 *  structures to hold a saved screen image + cursor info
 *  
 *********************************************************************/

/* 
    the video BIOS returns cursor size and position packed 
    in one word each ... these structs show the layout
*/
    
typedef struct {
    UCHAR   bot;
    UCHAR   top;
} VID_CURS_SIZE;

typedef struct {
    UCHAR   col;
    UCHAR   row;
} VID_CURS_POSN;

typedef struct {
    VID_CURS_POSN   c_posn;
    VID_CURS_SIZE   c_size;
    VIDCHR          v_buff[VID_MAX_ROWS][VID_MAX_COLS];
}   VID_SCR_BUFF;

#define VID_BUFF_SIZE   (VID_MAX_ROWS * VID_MAX_COLS * 2)

/**********************************************************************
 *  
 *  values for video modes returned by BIOS
 *  
 *********************************************************************/

#define VID_MONO_80x25      7
#define VID_BandW_80x25     2
#define VID_COLOR_80x25     3

/**********************************************************************
 *  
 *  values for video buffer addresses
 *  
 *********************************************************************/

#define VID_MONO_ADDR   0xb0000000L
#define VID_COLOR_ADDR  0xb8000000L

#endif  /* __PCVIDEO__ */


