/*---------------------------------------------------------------------------+
 |  FPU_emu.c                                                                |
 |                                                                           |
 | The glue between wm-FPU-emu and djgpp                                     |
 |                                                                           |
 | Copyright (C) 1994                                                        |
 |                       W. Metzenthen, 22 Parker St, Ormond, Vic 3163,      |
 |                       Australia.  E-mail   billm@vaxc.cc.monash.edu.au    |
 |                                                                           |
 | See the files "README" and "COPYING" for further copyright and warranty   |
 | information.                                                              |
 |                                                                           |
 +---------------------------------------------------------------------------*/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>		/* for write() */
#include <strings.h>
#include <linux/signal.h>
#include "fpu_system.h"


extern void math_emulate (void);

union i387_union I387;

struct info FPU__info =
{0, 0};

struct task_struct _current =
{0, 0};

static unsigned long signal;

extern void 
FPU_emu (void)
{
  asm volatile (" \
      movl %%eax, %0; \
      movl %%ebx, %1; \
      movl %%ecx, %2; \
      movl %%edx, %3; \
      movl %%esi, %4; \
      movl %%edi, %5; \
      movl %%ebp, %6; \
      movl %%esp, %7; \
      movl (%%esp), %%eax; \
      movl %%eax, %8; \
      ":
		"=m" (FPU__info.___eax), "=m" (FPU__info.___ebx),
		"=m" (FPU__info.___ecx), "=m" (FPU__info.___edx),
		"=m" (FPU__info.___esi), "=m" (FPU__info.___edi),
		"=m" (FPU__info.___ebp), "=m" (FPU__info.___esp),
		"=m" (FPU__info.___eip));

  (FPU__info.___esp) += 12;	/* The %esp when the FPU instr was encountered */

  signal = 0;

  math_emulate ();

  if (signal == SIGFPE)
    {
      asm volatile ("int $16");
      printk ("ERROR: FPU interrupt 16 returned to FPU emulator.\n");
      exit (1);
    }

  asm volatile (" \
      movl %7, %%eax; \
      movl %%eax, (%%esp); \
      movl %0, %%eax; \
      movl %1, %%ebx; \
      movl %2, %%ecx; \
      movl %3, %%edx; \
      movl %4, %%esi; \
      movl %5, %%edi; \
      movl %6, %%ebp; \
      iret; \
      ": /* No output */ :
		"m" (FPU__info.___eax), "m" (FPU__info.___ebx),
		"m" (FPU__info.___ecx), "m" (FPU__info.___edx),
		"m" (FPU__info.___esi), "m" (FPU__info.___edi),
		"m" (FPU__info.___ebp), "m" (FPU__info.___eip));

}


int 
send_sig (unsigned long sig, struct task_struct *p, int priv)
{
  signal = sig;
}


void 
_math_abort (int x)
{
  panic ("Aborting FPU emulator...");
}


void
#ifdef DJGPP_INCLUDES
 volatile
#endif
exit (int n)
{
  _exit (n);
}


volatile void 
panic (const char *str)
{
  printk (str);
  exit (1);
}


int 
printk (const char *f,...)
{
  char buf[1000];
  vsprintf (buf, f, (&f) + 1);
  return write (2, buf, strlen (buf));
}
