*** orig/make-3.71/dir.c	Thu Jul 21 01:29:56 1994
--- src/make-3.71/dir.c	Thu Jul 21 01:32:44 1994
***************
*** 47,52 ****
--- 47,88 ----
  #define REAL_DIR_ENTRY(dp) (dp->d_ino != 0)
  #endif /* POSIX */
  
+ #ifdef __MSDOS__
+ #include <ctype.h>
+ char *dosify(char *filename)
+ {
+   static char dos_filename[14];
+   char *df;
+   int i;
+ 
+   if (filename == 0)
+     return 0;
+   if (strpbrk(filename, "\"*+,;<=>?[\\]|"))
+     return filename;
+   df = dos_filename;
+   /* first, transform the name part */
+   for (i=0; *filename && i<8 && *filename != '.'; i++)
+     *df++ = tolower(*filename++);
+   /* now skip to the next dot */
+   while (*filename && *filename != '.')
+     filename ++;
+   if (*filename)
+   {
+     *df++ = *filename++;
+     for (i=0; *filename && i<3 && *filename != '.'; i++)
+       *df++ = tolower(*filename++);
+   }
+   /* look for more dots */
+   while (*filename && *filename != '.')
+     filename++;
+   if (*filename == '.')
+     return filename;
+   *df = 0;
+   return dos_filename;
+ }
+ 
+ #endif /* __MSDOS__ */
+ 
  /* Hash table of directories.  */
  
  #ifndef	DIRECTORY_BUCKETS
***************
*** 213,218 ****
--- 249,258 ----
      /* The directory could not be stat'd or opened.  */
      return 0;
  
+ #ifdef __MSDOS__
+   filename = dosify(filename);
+ #endif
+ 
    hash = 0;
    if (filename != 0)
      {
***************
*** 403,408 ****
--- 443,452 ----
    if (dir == 0 || dir->files == 0)
      /* There are no files entered for this directory.  */
      return 0;
+ 
+ #ifdef __MSDOS__
+   p = filename = dosify(p);
+ #endif
  
    for (hash = 0; *p != '\0'; ++p)
      HASH (hash, *p);
