/* Copyright (C) 2009 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <libc/stubs.h>
#include <unistd.h>
#include <dpmi.h>
#include <errno.h>
#include <libc/dosio.h>

#include "../include/libc/fd_props.h"
#include "libsupp.h"

int libsupp_fsync_2_03(int _fd);


int
libsupp_fsync_2_03(int _fd)
{
  int oerrno = errno;
  __dpmi_regs r;

  /* Directory? If so, fail. */
  if (libsupp___get_fd_flags(_fd) & FILE_DESC_DIRECTORY)
  {
    errno = EINVAL;
    return -1;
  }

  r.h.ah = 0x68;
  r.x.bx = _fd;
  __dpmi_int(0x21, &r);
  if ((r.x.flags & 1) && (r.x.ax != 1) && (r.x.ax != 6))
  {
    errno = __doserr_to_errno(r.x.ax);
    return -1;
  }
  errno = oerrno;
  return 0;
}
