/* Copyright (C) 2008 DJ Delorie, see COPYING.DJ for details */
#include <stdlib.h>
#include <string.h>

#include "libsupp.h"


void
libsupp_argz_delete(char **argz, size_t *argz_len, char *entry)
{
  /*
   *  Delete ENTRY from the argz vector in ARGZ
   *  adjusting its length ARGZ_LEN accordingly.
   */

  if (entry)
  {
    size_t entry_len = strlen(entry) + 1;

    *argz_len -= entry_len;
    memmove(entry, entry + entry_len, *argz_len - (entry - *argz));
    if (*argz_len == 0)
    {
      free(*argz);
      *argz = NULL;
    }
  }
}
