/* Copyright (C) 2009 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 2003 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 2001 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 2000 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 1999 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 1998 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 1997 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 1996 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <libc/stubs.h>
#include <limits.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/stat.h>
#include <io.h>
#include <sys/fsext.h>

#include <libc/dosio.h>

#include "../include/stdbool.h"
#include "../include/libc/fd_props.h"
#include "../include/libc/unconst.h"
#include "libsupp.h"

#define IS_DRIVE_SPECIFIER(path)  ((path)[0] && ((path)[1] == ':'))
#define IS_ROOT_DIR(path)         ((IS_DRIVE_SPECIFIER(path) && IS_SLASH(path[2]) && ((path)[3] == '\0')) || \
                                   (IS_SLASH(path[0]) && ((path)[1] == '\0')))
#define IS_SLASH(path)            ((path) == '/' || (path) == '\\')


/* Extra share flags that can be indicated by the user */
int __djgpp_share_flags;

int   libsupp_open_2_03(const char* _filename, int _oflag, ...);
int   libsupp_access_2_03(const char *_fn, int _flags);
int   libsupp_close_2_03(int _handle);
int   libsupp_fcntl_2_03(int _fd, int _cmd, ...);
int   libsupp__close_2_03(int _handle);
int   libsupp__write_2_03(int _handle, const void* _buffer, size_t _count);
off_t libsupp_lseek_2_03(int _handle, off_t _offset, int _whence);


/* Move a file descriptor FD such that it is at least MIN_FD.
   If the file descriptor is changed (meaning it was origially
   *below* MIN_FD), the old one will be closed.
   If the operation failed (no more handles available?), -1 will
   be returned, in which case the original descriptor is still
   valid.

   This jewel is due to Morten Welinder <terra@diku.dk>.  */
static int
move_fd(int fd, int min_fd)
{
  int new_fd, tmp_fd;

  if (fd == -1 || fd >= min_fd)
    return fd;

  tmp_fd = dup (fd);
  if (tmp_fd == -1)
    return tmp_fd;

  new_fd = move_fd (tmp_fd, min_fd);
  if (new_fd != -1)
    libsupp_close_2_03(fd);      /* success--get rid of the original descriptor */
  else
    libsupp_close_2_03(tmp_fd);  /* failure--get rid of the temporary descriptor */
  return new_fd;
}

static int
opendir_as_fd(const char *filename, const int oflag)
{
  int fd, old_fd, flags, ret;

  /* Check the flags. */
  if ((oflag & (O_RDONLY | O_WRONLY | O_RDWR)) != O_RDONLY)
  {
    /* Only read-only access is allowed. */
    errno = EISDIR;
    return -1;
  }

  /*
   * Allocate a file descriptor that:
   *
   * - is dup'd off nul, so that bogus operations at least go somewhere
   *   sensible;
   * - is in binary mode;
   * - is non-inheritable;
   * - is marked as a directory.
   *
   * __FSEXT_alloc_fd() conveniently handles the first two. File handles
   * greater than 19 are not inherited, due to a misfeature
   * of the DOS exec call.
   */
  old_fd = __FSEXT_alloc_fd(NULL);
  if (old_fd < 0)
    return -1; /* Pass through errno. */

  fd = move_fd(old_fd, 20);
  if (fd < 0)
  {
    libsupp_close_2_03(old_fd);
    errno = EMFILE;
    return -1;
  }

  libsupp___set_fd_properties(fd, filename, 0);
  libsupp___set_fd_flags(fd, FILE_DESC_DIRECTORY);

  flags = libsupp_fcntl_2_03(fd, F_GETFD);
  if (flags < 0)
    return -1; /* Pass through errno. */
  flags |= FD_CLOEXEC;
  ret = libsupp_fcntl_2_03(fd, F_SETFD, flags);
  if (ret < 0)
    return -1; /* Pass through errno. */

  return fd;
}

int
libsupp_open_2_03(const char* filename, int oflag, ...)
{
  const int original_oflag = oflag;
  int fd, dmode, bintext;
  bool should_create = (oflag & (O_CREAT | O_EXCL)) == (O_CREAT | O_EXCL);
  bool dont_have_share, is_root_dir;
  size_t length;


  if (!(length = strlen(filename)))
  {
    errno = EINVAL;
    return -1;
  }
  else
    is_root_dir = IS_ROOT_DIR(filename);

  /* According to POSIX: If the filename contains at least one
     non-slash character and ends with one or more trailing slashes
     and one of O_CREAT, O_WRONLY, O_RDWR is specified, then fail.  */
  if (((oflag & (O_RDONLY | O_CREAT | O_WRONLY | O_RDWR)) != O_RDONLY) && \
      !is_root_dir && IS_SLASH(filename[length - 1]))
  {
    errno = EISDIR;
    return -1;
  }

  /* Check this up front, to reduce cost and minimize effect */
  if (should_create)
    if (__file_exists(filename))
    {
      /* file exists and we didn't want it to */
      errno = EEXIST;
      return -1;
    }

  /* figure out what mode we're opening the file in */
  bintext = oflag & (O_TEXT | O_BINARY);
  if (!bintext)
    bintext = _fmode & (O_TEXT | O_BINARY);
  if (!bintext)
    bintext = O_BINARY;

  /* DOS doesn't want to see these bits */
  oflag &= ~(O_TEXT | O_BINARY);

  dmode = (*((&oflag)+1) & S_IWUSR) ? 0 : 1;

  /* Merge the share flags if they are specified */
  dont_have_share = ((oflag &
                     (SH_DENYNO | SH_DENYRW | SH_DENYRD | SH_DENYWR)) == 0);
  if (dont_have_share && __djgpp_share_flags)
  {
    dont_have_share = false;
    oflag |= __djgpp_share_flags;
  }

  if (should_create)
    fd = _creatnew(filename, dmode, oflag & 0xff);
  else
  {
    fd = _open(filename, oflag);

    if (fd == -1)
    {
      /* It doesn't make sense to try anything else if there are no
	 more file handles available.  */
      if (errno == EMFILE || errno == ENFILE)
        return fd;

      if (__file_exists(filename))
      {
        /* Under multi-taskers, such as Windows, our file might be
           open by some other program with DENY-NONE sharing bit,
           which fails the `_open' call above.  Try again with
           DENY-NONE bit set, unless some sharing bits were already
           set in the initial call.  */
        if (dont_have_share)
          fd = _open(filename, oflag | SH_DENYNO);
      }
      /* Don't call _creat on existing files for which _open fails,
         since the file could be truncated as a result.  */
      else if ((oflag & O_CREAT))
        fd = _creat(filename, dmode);
    }
    else
      /* According to POSIX: If the named file without the slash
         is not a directory, open() must fail with ENOTDIR.  */
      if (!is_root_dir && IS_SLASH(filename[length - 1]) && libsupp_access_2_03(filename, D_OK))
      {
        libsupp_close_2_03(fd);
        errno = ENOTDIR;
        return -1;
      }
  }

  /* Is the target a directory? If so, generate a file descriptor
   * for the directory. Skip the rest of `open', because it does not
   * apply to directories. */
  if ((fd == -1) && (libsupp_access_2_03(filename, D_OK) == 0))
    return opendir_as_fd(filename, original_oflag);

  if (fd == -1)
    return fd;	/* errno already set by _open or _creat */

  if ((oflag & O_TRUNC) && !should_create)
#ifndef TRUNC_CHECK
    libsupp__write_2_03(fd, 0, 0);
#else
    /* Windows 2000/XP will fail 0 byte writes (truncate) on a character
       device (nul, con) if opened with lfn calls.  We can either ignore
       the return completely or ignore errors on NT.  Since a truncate
       fail should never happen (and if it does we expect an error on
       the next write) this probably doesn't make much difference. */

    if (libsupp__write_2_03(fd, 0, 0) < 0 && _os_trueversion != 0x532)
    {
      libsupp__close_2_03(fd);
      return -1;
    }
#endif

  /* we do this last because _open and _create set it also. */
  /* force setmode() to do ioctl() for cooked/raw */
  __file_handle_set(fd, bintext ^ (O_BINARY|O_TEXT));
  /* this will do cooked/raw ioctl() on character devices */
  setmode(fd, bintext);
  libsupp___set_fd_properties(fd, filename, oflag);

  if (oflag & O_APPEND)
    libsupp_lseek_2_03(fd, 0, SEEK_END);

  return fd;
}

