#! /bin/sh

name=mpc
version=1.0.2

djver1=`echo $version | sed -e 's:\.::2g'`
djver2=`echo $version | sed -e 's:\.::g'`
dname=$name-$djver1

rm -rf inst.djg
make all check
make check >check.log 2>&1
make install prefix=`pwd`/inst.djg
make check >check.log 2>&1

mkdir -p inst.djg/info
mkdir -p inst.djg/manifest
mkdir -p inst.djg/gnu/$dname

cp -v check.log inst.djg/gnu/$dname/

touch inst.djg/manifest/${name}${djver2}b.mft

cat >inst.djg/manifest/${name}${djver2}b.ver <<E2
${name}${djver2}s.zip: MPC - C library for multiple-precision complex computations (sources)
E2

mv -v inst.djg/share/info/*.info inst.djg/info/
cp -v authors bugs COPYING* inst.djg/gnu/$dname/
cp -v news readme* todo inst.djg/gnu/$dname/
cp -vf check.log inst.djg/gnu/$dname/
rm -rf inst.djg/share

( cd inst.djg && find . -type f | sed -e 's:^\./::' | sort >manifest/${name}${djver2}b.mft )
( cd inst.djg && cat manifest/${name}${djver2}b.mft | zip -9@ ../${name}${djver2}b.zip )
