/* houseKeeping.h - housekeeping methods
*/
#ifndef LSW1_HOUSEKEEPING_H
#define LSW1_HOUSEKEEPING_H
/*****************************************************************Includes*/
#include <swing.h>
/******************************************************************Defines*/
// pre-defined errors & messages:
//      name               code   message
// generic errors
#define EUNKN              0x0000 // unknown error
#define EARGINVAL          0x8000 // invalid use of command-line arguments
#define EMEMIO             0x8001 // memory access failed
#define ERENAME            0x8002 // renaming a file failed
#define ERECNOINVAL        0x8003 // request for a record with an invalid record number
#define ENOIMPL            0x8004 // not implemented
// errors that may occur in VPL3
#define EOPENSHIPDB        0xF000 // opening ships database failed
#define ECLOSESHIPDB       0xF001 // closing ships database failed
#define EREADSHIPDB        0xF002 // reading from ships database failed
#define EWRITESHIPDB       0xF003 // writing to ships database failed
#define EOPENSHIPXYDB      0xF004 // opening ship coordinat database failed
#define ECLOSESHIPXYDB     0xF005 // closing ship coordinat database failed
#define EREADSHIPXYDB      0xF006 // reading from ship coordinat database failed
#define EWRITESHIPXYDB     0xF007 // writing to ship coordinat database failed
#define EOPENCLOAKDB       0xF008 // opening cloak database failed
#define ECLOSECLOAKDB      0xF009 // closing cloak database failed
#define EREADCLOAKDB       0xF00A // reading cloak database failed
#define EWRITECLOAKDB      0xF00B // writing cloak database failed
#define EOPENPLANETDB      0xF00C // opening planet database failed
#define ECLOSEPLANETDB     0xF00D // closing planet database failed
#define EREADPLANETDB      0xF00E // reading planet database failed
#define EWRITEPLANETDB     0xF00F // writing planet database failed
#define EOPENPLANETXYDB    0xF010 // opening planet coordinat database failed
#define ECLOSEPLANETXYDB   0xF011 // closing planet coordinat database failed
#define EREADPLANETXYDB    0xF012 // reading planet coordinat database failed
#define EWRITEPLANETXYDB   0xF013 // writing planet coordinat database failed
#define EOPENPLANETNMDB    0xF014 // opening planet name database failed
#define ECLOSEPLANETNMDB   0xF015 // closing planet name database failed
#define EREADPLANETNMDB    0xF016 // reading planet name database failed
#define EWRITEPLANETNMDB   0xF017 // writing planet name database failed
#define EOPENSTARBASEDB    0xF018 // opening starbase database failed
#define ECLOSESTARBASEDB   0xF019 // closing starbase database failed
#define EREADSTARBASEDB    0xF01A // reading starbase database failed
#define EWRITESTARBASEDB   0xF01B // writing starbase database failed
#define EOPENENGINEDB      0xF01C // opening engine database failed
#define ECLOSEENGINEDB     0xF01D // closing engine database failed
#define EREADENGINEDB      0xF01E // reading engine database failed
#define EWRITEENGINEDB     0xF01F // writing engine database failed
#define EOPENBEAMDB        0xF020 // opening beam database failed
#define ECLOSEBEAMDB       0xF021 // closing beam database failed
#define EREADBEAMDB        0xF022 // reading beam database failed
#define EWRITEBEAMDB       0xF023 // writing beam database failed
#define EOPENTORPEDODB     0xF024 // opening torpedo database failed
#define ECLOSETORPEDODB    0xF025 // closing torpedo database failed
#define EREADTORPEDODB     0xF026 // reading torpedo database failed
#define EWRITETORPEDODB    0xF027 // writing torpedo database failed
#define EOPENHULLDB        0xF028 // opening hull database failed
#define ECLOSEHULLDB       0xF029 // closing hull database failed
#define EREADHULLDB        0xF02A // reading hull database failed
#define EWRITEHULLDB       0xF02B // writing hull database failed
#define EOPENGENDB         0xF02C // opening general database failed
#define ECLOSEGENDB        0xF02D // closing general database failed
#define EREADGENDB         0xF02E // reading general database failed
#define EWRITEGENDB        0xF02F // writing general database failed
#define EOPENRACENMDB      0xF030 // opening race name database failed
#define ECLOSERACENMDB     0xF031 // closing race name database failed
#define EREADRACENMDB      0xF032 // reading race name database failed
#define EWRITERACENMDB     0xF033 // writing race name database failed
#define EOPENHCONFIGFILE   0xF034 // opening host config file failed
#define ECLOSEHCONFIGFILE  0xF035 // closing host config file failed
#define EREADHCONFIGFILE   0xF036 // reading host config file failed
#define EWRITEHCONFIGFILE  0xF037 // writing host config file failed
#define EOPENGREYDB        0xF038 // opening grey database failed
#define ECLOSEGREYDB       0xF039 // closing grey database failed
#define EREADGREYDB        0xF03A // reading grey database failed
#define EWRITEGREYDB       0xF03B // writing grey database failed
#define EOPENMINESDB       0xF03C // opening mine field database failed
#define ECLOSEMINESDB      0xF03D // closing mine field database failed
#define EREADMINESDB       0xF03E // reading mine field database failed
#define EWRITEMINESDB      0xF03F // writing mine field database failed
#define EOPENUFODB         0xF040 // opening UFO database failed
#define ECLOSEUFODB        0xF041 // closing UFO database failed
#define EREADUFODB         0xF042 // reading UFO database failed
#define EWRITEUFODB        0xF043 // writing UFO database failed
#define EOPENBHULLDB       0xF044 // opening database of buildable hulls failed
#define ECLOSEBHULLDB      0xF045 // closing database of buildable hulls failed
#define EREADBHULLDB       0xF046 // reading database of buildable hulls failed
#define EWRITEBHULLDB      0xF047 // writing database of buildable hulls failed
#define EOPENRACESDB       0xF048 // opening database of actual races failed
#define ECLOSERACESDB      0xF049 // closing database of actual races failed
#define EREADRACESDB       0xF04A // reading database of actual races failed
#define EWRITERACESDB      0xF04B // writing database of actual races failed
#define EREADCONFIGREC     0xF04C // reading a config record failed
#define EREADSHIPREC       0xF04D // reading a ship record failed
#define EREADPLANETREC     0xF04E // reading a planet record failed
#define EREADSTARBASEREC   0xF04F // reading a starbase record failed
#define EREADRACEREC       0xF050 // reading a race record failed
#define EREADMINEFIELDREC  0xF051 // reading a minefield record failed
#define EREADIONSTORMREC   0xF052 // reading an ion storm record failed
#define EREADUFOREC        0xF053 // reading a UFO record failed
#define EREADHOSTREC       0xF054 // reading a host record failed
#define EREADPLAYERREC     0xF055 // reading a player record failed
#define EREADIMESSAGEREC   0xF056 // reading an incoming message record failed
#define EREADOMESSAGEREC   0xF057 // reading an outgoing message record failed
#define EWRITECONFIGREC    0xF058 // writing a config record failed
#define EWRITESHIPREC      0xF059 // writing a ship record failed
#define EWRITEPLANETREC    0xF05A // writing a planet record failed
#define EWRITESTARBASEREC  0xF05B // writing a starbase record failed
#define EWRITERACEREC      0xF05C // writing a race record failed
#define EWRITEMINEFIELDREC 0xF05D // writing a minefield record failed
#define EWRITEIONSTORMREC  0xF05E // writing an ion storm record failed
#define EWRITEUFOREC       0xF05F // writing a UFO record failed
#define EWRITEHOSTREC      0xF060 // writing a host record failed
#define EWRITEPLAYERREC    0xF061 // writing a player record failed
#define EWRITEIMESSAGEREC  0xF062 // writing an incoming message record failed
#define EWRITEOMESSAGEREC  0xF063 // writing an outgoing message record failed
#define EOPENTARGETDB      0xF064 // opening target database failed
#define ECLOSETARGETDB     0xF065 // closing target database failed
#define EREADTARGETDB      0xF066 // reading from target database failed
#define EWRITETARGETDB     0xF067 // writing to target database failed
#define EOPENMESSDB        0xF068 // opening outgoing message database failed
#define ECLOSEMESSDB       0xF069 // closing outgoing message database failed
#define EREADMESSDB        0xF06A // reading from outgoing message database failed
#define EWRITEMESSDB       0xF06B // writing to outgoing message database failed
#define EOPENMDATADB       0xF06C // opening incoming message database failed
#define ECLOSEMDATADB      0xF06D // closing incoming message database failed
#define EREADMDATADB       0xF06E // reading from incoming message database failed
#define EWRITEMDATADB      0xF06F // writing to incoming message database failed
#define EOPENTURNDB        0xF070 // opening turn database failed
#define ECLOSETURNDB       0xF071 // closing turn database failed
#define EREADTURNDB        0xF072 // reading turn database failed
#define EWRITETURNDB       0xF073 // writing turn database failed
// errors that may occur in Gators
#define EOPENGTR2GTRDB     0xF100 // opening GTR2 Gators database failed
#define ECLOSEGTR2GTRDB    0xF101 // closing GTR2 Gators database failed
#define EREADGTR2GTRDB     0xF102 // reading GTR2 Gators database failed
#define EWRITEGTR2GTRDB    0xF103 // writing GTR2 Gators database failed
#define EOPENGTR2CFGFILE   0xF104 // opening GTR2 configuration file failed
#define ECLOSEGTR2CFGFILE  0xF105 // closing GTR2 configuration file failed
#define EREADGTR2CFGFILE   0xF106 // reading GTR2 configuration file failed
#define EWRITEGTR2CFGFILE  0xF107 // writing GTR2 configuration file failed
#define EOPENGTR3GTRDB     0xF108 // opening Gators database failed
#define ECLOSEGTR3GTRDB    0xF109 // closing Gators database failed
#define EREADGTR3GTRDB     0xF10A // reading Gators database failed
#define EWRITEGTR3GTRDB    0xF10B // writing Gators database failed
#define EOPENGTR3CFGFILE   0xF10C // opening configuration file failed
#define ECLOSEGTR3CFGFILE  0xF10D // closing configuration file failed
#define EREADGTR3CFGFILE   0xF10E // reading configuration file failed
#define EWRITEGTR3CFGFILE  0xF10F // writing configuration file failed
#define EOPENGTR3SPUDB     0xF110 // opening warped ship database failed
#define ECLOSEGTR3SPUDB    0xF111 // closing warped ship database failed
#define EREADGTR3SPUDB     0xF112 // reading warped ship database failed
#define EWRITEGTR3SPUDB    0xF113 // writing warped ship database failed
#define EOPENGTR3LNKDB     0xF114 // opening parallel universe ship database failed
#define ECLOSEGTR3LNKDB    0xF115 // closing parallel universe ship database failed
#define EREADGTR3LNKDB     0xF116 // reading parallel universe ship database failed
#define EWRITEGTR3LNKDB    0xF117 // writing parallel universe ship database failed
#define EOPENGTR3LXYDB     0xF118 // opening parallel universe ship coordinat database failed
#define ECLOSEGTR3LXYDB    0xF119 // closing parallel universe ship coordinat database failed
#define EREADGTR3LXYDB     0xF11A // reading parallel universe ship coordinat database failed
#define EWRITEGTR3LXYDB    0xF11B // writing parallel universe ship coordinat database failed
// Starbase Enhancer errors
#define EALLOCCMPBUF       0xF200 // allocating component table buffer failed
#define EOPENCMPFILE       0xF201 // openening component table file failed
#define ECLOSECMPFILE      0xF202 // closing component table file failed
#define EREADCMPFILE       0xF203 // reading component table file failed
#define EWRITECMPFILE      0xF204 // writing component table file failed
#define EALLOCTSBBUF       0xF205 // allocating towed starbase table buffer failed
#define EOPENTSBFILE       0xF206 // openening towed starbase table file failed
#define ECLOSETSBFILE      0xF207 // closing towed starbase table file failed
#define EREADTSBFILE       0xF208 // reading towed starbase table file failed
#define EWRITETSBFILE      0xF209 // writing towed starbase table file failed
#define EOPENENHSBDB       0xF20A // opening the enhanced starbases database failed
#define ECLOSEENHSBDB      0xF20B // closing the enhanced starbases database failed
#define EREADENHSBDB       0xF20C // reading the enhanced starbases database failed
#define EWRITEENHSBDB      0xF20D // writing the enhanced starbases database failed
// Generic VGA Planets errors & warnings
#define EUFOSLOTSFULL      0xFF00 // all UFO slots are full
#define EUFODBFULL         EUFOSLOTSFULL
/*******************************************************Structural defines*/
typedef struct _errorType { // See comment 1
  bool  isDefined;          // always true (except in empty error)
  int   code;               // number of the error
  char  *errorMessage;      // message displayed for the error
  bool  (*handler)(void);   // handler for the error
  bool  isFatal;            // is this error always fatal?
  void  *data;              // data to be passed to the handler (or NULL if none)
} errorType;
/******************************************************************Globals*/
extern errorType *errors;
extern int errCode;
/**********************************************************Library methods*/
bool initHouseKeeping(void);
bool doneHouseKeeping(void);
/*****************************************************Housekeeping methods*/
bool addError(errorType *e);
bool removeError(int e);
void beep(void);
bool isFatal(int e);
void done(int e) __attribute__((noreturn));
void cancel(int e) __attribute__((noreturn));
void warning(int e);
/***************************************************Error-handling methods*/
bool handle(int e);
/*****************************************************************Comments**
// 1. An array of known errors has been defined. Each of them has its own
//    number, message, handler (if any) and fatality. This is (ofcourse)
//    errors[]. You can add to this array using addError() or remove from
//    this array with removeError(). Read the documentation for details.
***************************************************************************/
#endif // LSW1_HOUSEKEEPING_H
