/*
 * sock_init - easy way to guarentee:
 *      - card is ready
 *      - shutdown is handled
 *      - cbreaks are handled
 *      - config file is read
 *      - bootp is run
 *
 * 0.1 : May 2, 1991  Erick - reorganized operations
 */

#include <copyright.h>
#include <wattcp.h>
#include <stdlib.h>

word _survivebootp = 0;

void sock_exit()
{
    tcp_shutdown();
}

int _sock_init()
{
    if (!tcp_init())            /* must precede tcp_config because we need eth addr */
      return 0;

    atexit(sock_exit);  /* must not precede tcp_init() incase no PD */

    if (tcp_config( NULL )) {   /* if no config file use BOOTP w/broadcast */
        _bootpon = 1;
        outs("Configuring through BOOTP\r\n");
    }

    if (_bootpon)       /* non-zero if we use bootp */
        if (_dobootp()) {
            outs("BOOTP failed\r\n");
            if ( !_survivebootp )
                return 0;
        }
   return 1;
}

void sock_init (void)
{
  if (!_sock_init())
    exit(3);
}
