/* --------------------------------------------------------------------------
   Project S.W.O.R.D
   V2.10

   SubSystem : Sample programs : Common application
   File      : Samples/Common/Common.cc
   Author    : Eric NICOLAS
   Overview  : Main file for the Common sample program
   UpDate    : Mar 13, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#include "common/common.h"
#include "drivers/drivers.h"

int main(int , char *argv[])
{ char TimeStr[50];
  char DateStr[50];

  // Application identification
  ShortVersion="Common tests";
  LongVersion ="Common tests. Copyright (C) 1993-1996 The SWORD Group";

  // Init
  InitCommon(argv[0]);
  InitDrivers();
  printf("\n\nTESTS for the COMMON kit.\n\n");
  // Random tests
  { int  i,r,min,max;
    long mean;
    printf("RANDOM tests. 10000 Random numbers between 1 and 100 : \n");
	 min=(int)MaxInt; max=(int)MinInt;
	 mean=0;
    for(i=0;i<10000;i++)
	 { r=Random(100)+1;
      if (r<min) min=r;
      if (r>max) max=r;
      mean+=r;
    }
    mean/=10000;
    printf("   Min=%d  Max=%d  Mean=%ld\n\n",min,max,mean);
  }
  // System Time tests
  { int i;
	 printf("TIME tests. I am going to count 10 times a 1 sec delay : \n");
	 printf("0... "); fflush(stdout);
	 for(i=1;i<=10;i++)
	 { Delay(100);
		printf("%d... ",i); fflush(stdout);
	 }
	 printf("\n\n");
    printf("press [return]...\n");
    getc(stdin);
  }
  // Legal Time test
  { TTimeDate TD;
    TD.WriteTime(TimeStr);
    TD.WriteDate(DateStr);
    printf("The legal time is : %s\n"  ,TimeStr);
    printf("The legal date is : %s\n",DateStr);
    printf("\n");
    printf("press [return]...\n");
    getc(stdin);
  }
  // Directory listing test
  { boolean   Finished;
    TDirEntry Entry;
    void      *SearchHandle;
    printf("Listing of directory '.' :\n");
    SearchHandle=OpenDirList(".");
    if (Error) printf("Impossible to read entries of '.' directory !!\n\n");
    else
    { Finished=ReadDirEntry(Entry,SearchHandle);
      while(!Finished)
      { Entry.Time.WriteTime(TimeStr);
        Entry.Time.WriteDate(DateStr);
        printf("%20s Dir:%d (Time:%s) (Date:%s)\n",
               Entry.FName,Entry.Directory,TimeStr,DateStr);
        Finished=ReadDirEntry(Entry,SearchHandle);
      }
      CloseDirList(SearchHandle);
    }
    printf("\n");
    printf("press [return]...\n");
    getc(stdin);
  }
  // Time formats tests
  { printf("Time formats demo (fake time) : \n");
    TTimeDate T;
    T.Hour=10; T.Minute=5; T.Second=9;
    T.SetTimeFormat("HH:MM:SS"); T.WriteTime(TimeStr);
    printf("  Format \"HH:MM:SS\"          : %s\n",TimeStr);
    T.SetTimeFormat("H:M:S"); T.WriteTime(TimeStr);
    printf("  Format \"H:M:S\"             : %s\n",TimeStr);
    T.SetTimeFormat("HH:MM S"); T.WriteTime(TimeStr);
    printf("  Format \"HH:MM S\"           : %s\n",TimeStr);
    printf("\n");
    printf("press [return]...\n");
    getc(stdin);
  }
  // Date formats tests
  { printf("Date formats demo (fake date) : \n");
    TTimeDate T;
    T.DayInWeek=1; T.Day=5; T.Month=3; T.Year=1996;
    T.SetDateFormat("MMT D, YY"); T.WriteDate(DateStr);
    printf("  Format \"MMT D, YY\"         : %s\n",DateStr);
    T.SetDateFormat("DT, MT D"); T.WriteDate(DateStr);
    printf("  Format \"DT, MT D\"          : %s\n",DateStr);
    T.SetDateFormat("DDT, DE of MMT YY"); T.WriteDate(DateStr);
    printf("  Format \"DDT, DE of MMT YY\" : %s\n",DateStr);
    printf("\n");
    printf("press [return]...\n");
    getc(stdin);
  }
  // Done
  DoneDrivers();
  DoneCommon();
  return 0;
}

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   15/02/96 :EN: First History remark
**   21/02/96 :EN: Transfert from old test/ directory to samples/ directory
**   13/03/96 :EN: Adding tests for Directory listing and new Time funcs
** ------------------------------------------------------------------------*/
