/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Screen graphics management
	File      : Include/Gadgets/Mapping.H
	Author    : Olivier PAYEN, Eric NICOLAS
	Overview  : TMapping Object : How to display bitmap
	UpDate    : Mar 03, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _GADGETS_MAPPING_H_
#define _GADGETS_MAPPING_H_

void InitMapping();
void DoneMapping();

// --- TScreenBitmap

extern short RegTScreenBitmap;
extern char *IdentTScreenBitmap;

class TScreenBitmap : public TAtom
{ DECLARE(TScreenBitmap);
  // -- Datas
  protected:
    GrContext *GC;
    int        W,H;
  // -- Methods
  public:
    // public Constructors
            TScreenBitmap();
            TScreenBitmap(int Width, int Height);
    // Creation / Destruction
            void Defaults(void);
            void Init(int Width, int Height);
            void Done();
            void NewSize(int Width, int Height);
    virtual void FreeMemory(void);
    virtual void GetMemory(void);
    // Put bitmap on the screen
			   void Draw(int X, int Y);
            void Draw(int Xs, int Ys, int Xd, int Yd, int Wd, int Hd);
    // Data access
            void BeginDraw(void);
            void EndDraw(void);
            int  Width();
            int  Height();
    // Objects streams
    virtual void Read(TDisk *file);
    virtual void Write(TDisk *file);
};

// --- TMapping

extern short RegTMapping;
extern char *IdentTMapping;

class TMapping : public TScreenBitmap
{ DECLARE(TMapping);
  // -- Datas
  protected:
    char      *Descr;
  // -- Functions
  public:
    // Public constructors
          TMapping();
          TMapping(int Width, int Height, char *Description);
    // Creation / Destruction
            void Defaults(void);
            void Init(int Width, int Height, char *Description=NULL);
    virtual void FreeMemory(void);
    virtual void GetMemory(void);
    // Graphics
            void DoMapping(TColor *ColorTable);
    virtual void SetColorGroup(char ColorGroup);
    // Objects streams
    virtual void Read(TDisk *file);
    virtual void Write(TDisk *file);
};

// -- TSysIcone

extern short RegTSysIcone;
extern char *IdentTSysIcone;

class TSysIcone : public TMapping
{ DECLARE(TSysIcone);
  public:
    // Public Constructors
           TSysIcone();
           TSysIcone(int Width, int Height, char *Description);
    // Creation / Destrction
    void    Defaults(void);
    void    Init(int Width, int Height, char *Description);
    // Objects streams
    virtual void Read(TDisk *file);
    virtual void Write(TDisk *file);
};

// -- TMappingObject

extern short RegTMappingObject;
extern char *IdentTMappingObject;

class TMappingObject : public TZone
{ DECLARE(TMappingObject);
  // -- Datas
  protected:
    TMapping *Mapp;
    boolean   DeleteMapp;
  // -- Functions
  public:
    // Public constructors
            TMappingObject();
            TMappingObject(int X, int Y, TMapping *_Mapp, boolean _DeleteMapp);
    // Creation / Destruction
            void Defaults();
            void Init(int X, int Y, TMapping *_Mapp, boolean _DeleteMapp);
            void Done(void);
    // Graphics
    virtual void     Draw(TRect Clip);
};

// Inline functions

inline int TScreenBitmap::Width()
{ return W;
}

inline int TScreenBitmap::Height()
{ return H;
}

#endif // _GADGETS_MAPPING_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   20/02/96 :EN: First History remark. Copying code V2.00->V2.10
**   22/02/96 :EN: Creation of TScreenBitmap. Portability to djgpp V2
**   28/02/96 :EN: Introduction of the 'Defaults' method
**   03/03/96 :EN: Changing color scheme so that it can be user-modified
** ------------------------------------------------------------------------*/
