/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem  : Little usefull graphical objects
	CommandNos : 3200..3299
	File       : Include/Gadgets/Lift.H
	Author     : Eric NICOLAS
	Overview   : TLift object
	UpDate     : Apr 08, 1996

** Copyright (C) 1993-1996 Eric NICOLAS
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _GADGETS_LIFT_H_
#define _GADGETS_LIFT_H_

#define cmLiftInc        3200
#define cmLiftDec        3201
#define cmLiftHorizMoved 3202
#define cmLiftVertMoved  3203

class TLiftButton;
class TLift;

// --- TLiftButton object

extern short RegTLiftButton;
extern char *IdentTLiftButton;

class TLiftButton : public TStdButton
{ DECLARE(TLiftButton);
  // --- Datas
  protected:
  // --- Functions
  public:
  // Public constructors
          TLiftButton(void);
          TLiftButton(int X, int Y, int Command, int ScanCode, char *IconeDescr);
  // Creation / Destruction
          void     Defaults(void);
          void     Init(int X, int Y, int Command, int ScanCode, char *IconeDescr);
  //
  virtual void     Action();
};

// --- TLift object

extern short RegTLift;
extern char *IdentTLift;

class TLift : public TZone
{ DECLARE(TLift);
  DECLARE_EVENTS_TABLE;
  // --- Datas
  protected:
	 boolean Horizontal;
	 TButton *Inc, *Dec;
	 int     Xctr,Lctr;
	 int     RealP1, RealP2;
	 int     ViewP1, ViewP2;
	 int     Step;
    int     ScanPageInc, ScanPageDec;
    TObject *Connected;
  // --- Functions
  public:
  // Public constructors
			 TLift(void);
			 TLift(int X, int Y, int L, int H, boolean _Horizontal);
			 TLift(TRect R, boolean _Horizontal);
  // Creation / Destruction
          void     Defaults(void);
			 void     Init(int X, int Y, int L, int H, boolean _Horizontal);
  // Lift elements size and position
  virtual void     ShrinkInside(TRect& InsideFather);
  virtual void     SizeChanged(void);
  // Access to data
			 void     SetViewPos(int P1, int P2, boolean Apply=TRUE);
			 void     SetRealPos(int P1, int P2, boolean Apply=TRUE);
			 void     SetIncStep(int _Step);
			 void     GetViewPos(int &P1, int &P2);
          void     SetConnectedObject(TObject *_Connected);
  //
          void     PageInc(void);
          void     PageDec(void);
          void     PageMove(TPoint dW);
  //
  virtual void     Draw(TRect Clip);
  // Events handling
  virtual boolean  MouseLDown(TPoint Where, int Buttons);
  virtual boolean  KeyDown(int ScanCode, int Toggle);
          boolean  doLiftDec(void);
          boolean  doLiftInc(void);
};

// --- Expanding inline functions

inline void TLift::SetViewPos(int P1, int P2, boolean Apply)
{ ViewP1=P1;
  ViewP2=P2;
  if (Apply) SizeChanged();
}

inline void TLift::SetRealPos(int P1, int P2, boolean Apply)
{ RealP1=P1;
  RealP2=P2;
  if (Apply) SizeChanged();
}

inline void TLift::SetIncStep(int _Step)
{ Step=_Step;
}

inline void TLift::GetViewPos(int &P1, int &P2)
{ P1=ViewP1;
  P2=ViewP2;
}

inline void TLift::SetConnectedObject(TObject *_Connected)
{ Connected=_Connected;
}

#endif // _GADGETS_LIFT_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   21/02/96 :EN: First History remark. Copying code V2.00->V2.10
**   29/02/96 :EN: Moving from struct to class. Adding Defaults() method
**   01/04/96 :EN: Adding DECLARE_COMMAND... macros
**   08/04/96 :EN: Changing from DECLARE_COMMAND... to DECLARE_EVENTS...
** ------------------------------------------------------------------------*/
