/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Basic functions usefull for all the system
	File      : Include/Common/Common.H
	Author    : Eric NICOLAS
	Overview  : Global header for Common module
	UpDate    : Apr 13, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _COMMON_COMMON_H_
#define _COMMON_COMMON_H_

#include "common/defines.h"
#include "common/types.h"
#include "common/error.h"
#include "common/debug.h"
#include "common/basic.h"

#define InitCommon(a)                    \
		  { InitDebug(DebugON);            \
          Debug("Initialisation...\n");  \
          InitError();                   \
          InitBasic(a);                  \
        }

#define DoneCommon()                     \
        { DoneBasic();                   \
          DoneError();                   \
          DoneDebug();                   \
        }

#endif // _COMMON_COMMON_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   15/02/96 :EN: First History remark. set includes paths to downcase.
**   13/04/96 :EN: Adding defines.h for automatic compiler detection
** ------------------------------------------------------------------------*/
