// Associated include file : ToolBox/Image/ImgView.H

#include "sword.h"
#include "toolbox/image/image.h"

// --- TImageScroller Object

DEFINE(TImageScroller);

short RegTImageScroller;
char *IdentTImageScroller = "TImageScroller";

TImageScroller::TImageScroller()
{ Defaults();
}

TImageScroller::TImageScroller(int X, int Y, int L, int H, TScreenBitmap *_Image, TLift *HLift, TLift *VLift)
{ Defaults();
  Init(X,Y,L,H,_Image,HLift,VLift);
}


TImageScroller::TImageScroller(TRect R, TScreenBitmap *_Image, TLift *HLift, TLift *VLift)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),R.Height(),_Image,HLift,VLift);
}

void TImageScroller::Defaults(void)
{ // Object Identification
  Register=RegTImageScroller;
  Ident=IdentTImageScroller;
  // Other Default Values
  Image=NULL;
}

void TImageScroller::Init(int X, int Y, int L, int H, TScreenBitmap *_Image, TLift *HLift, TLift *VLift)
{ // Herited constructions
  TScroller::Init(X,Y,L,H,_Image->Width(),_Image->Height(),HLift,VLift);
  // New constructions
  Image=_Image;
}

void TImageScroller::Draw(TRect )
{ int Limg=Image->Width()-DecX;
  int Himg=Image->Height()-DecY;
  if (Where.Width()<Limg) Limg=Where.Width();
  if (Where.Height()<Himg) Himg=Where.Height();
  Image->Draw(DecX,DecY,Corner.X(),Corner.Y(),Limg,Himg);
  // Termine la zone de l'objet par du noir
  SetSysColor(Black);
  if (Where.Width()>Limg) Bar(Limg,0,Where.Width()-1,Where.Height()-1);
  if (Where.Height()>Himg) Bar(0,Himg,Limg-1,Where.Height()-1);
}

// --- TImageViewer Object

DEFINE(TImageViewer);

short RegTImageViewer;
char *IdentTImageViewer = "TImageViewer";

TImageViewer::TImageViewer()
{ Defaults();
}

TImageViewer::TImageViewer(int X, int Y, int L, int H, char *Title, TScreenBitmap *_Image)
{ Defaults();
  Init(X,Y,L,H,Title,_Image);
}

TImageViewer::TImageViewer(TRect R, char *Title, TScreenBitmap *_Image)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),R.Height(),Title,_Image);
}

void TImageViewer::Defaults(void)
{ // Object Identification
  Register=RegTImageViewer;
  Ident=IdentTImageViewer;
  // Other default values
  Image=NULL;
}

void TImageViewer::Init(int X, int Y, int L, int H, char *Title, TScreenBitmap *_Image)
{ // Herited constructions
  TStdWindow::Init(X,Y,L,H,Title,opWinSizeable | opWinCloseBox);
  // New constructions
  Image=_Image;
  // Insre les ascenseurs
  TLift *VLift=new TLift(Inside,FALSE);
  Insert(VLift);
  TLift *HLift=new TLift(Inside,TRUE);
  Insert(HLift);
  //
  Insert(new TWindowIFrame(Inside));
  // Insre l'afficheur d'image
  Insert(CreateImageScroller(Inside,Image,HLift,VLift));
}

void TImageViewer::Done(void)
{ // Herited destructions
  TStdWindow::Done();
  // New destructions
  delete Image;
}

TImageScroller *TImageViewer::CreateImageScroller(TRect R, TScreenBitmap *_Image, TLift *HLift, TLift *VLift)
{ return new TImageScroller(R,_Image,HLift,VLift);
}