// Associated include file : Graphics/Gauge.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"
#include "gadgets/gadgets.h"

DEFINE(TGauge);

short RegTGauge;
char *IdentTGauge = "TGauge";

TGauge::TGauge()
{ Defaults();
}

TGauge::TGauge(int X, int Y, int L, int H)
{ Defaults();
  Init(X,Y,L,H);
}

TGauge::TGauge(TRect R)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),R.Height());
}

void TGauge::Defaults(void)
{ // Object identification
  Register=RegTGauge;
  Ident=IdentTGauge;
  // Other default values
  CurrentValue=0;
}

void TGauge::Init(int X, int Y, int L, int H)
{ // Herited creations
  TZone::Init(X,Y,L,H);
  // New creations
}

void TGauge::SetValue(int V)
{ if ((V<0) || (V>100)) return;
  if (V!=CurrentValue)
  { CurrentValue=V;
	 Invalidate(2,2,Where.Width()-3,Where.Height()-3);
  }
}

void TGauge::Draw(TRect )
{ // Fond
  int LProgress=(Where.Width()-4)*CurrentValue/100;
  // :: Part 1 : Progress status : Done
  if (LProgress>0)
  { SetSysColor(1);
    Bar(2,2,2+LProgress-1,Where.Height()-3);
  }
  // :: Part 2 : Progress status : To do
  if (LProgress<Where.Width()-4)
  { SetSysColor(2);
    Bar(2+LProgress,2,Where.Width()-3,Where.Height()-3);
  }
  // Frame
  Frame3D(1);
  // Texte
  SetSysColor(3);
  char Buffer[10];
  sprintf(Buffer,"%d %%",CurrentValue);
  FontSystem->XAlignCenter();
  FontSystem->YAlignCenter();
  FontSystem->ChooseFace(FFace_BOLD);
  PutStr(Where.Width()/2, Where.Height()/2, Buffer, FontSystem);
  FontSystem->ChooseFace(FFace_NORMAL);
  FontSystem->AlignDefault();
}