/***************************************************************************\
 *
 *  Messages for the Event Log 
 *  
 *  Note: the the message.h file is created by the MC tool
 *  
 *  usage: mc.exe message.mc
 *  
\***************************************************************************/
 /*
    Infamational messages
 */
//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//


//
// Define the severity codes
//
#define STATUS_SEVERITY_WARNING          0x2
#define STATUS_SEVERITY_SUCCESS          0x0
#define STATUS_SEVERITY_INFORMATIONAL    0x1
#define STATUS_SEVERITY_ERROR            0x3


//
// MessageId: EVENTLOGMSG_SERVICE_STARTED
//
// MessageText:
//
//  The service started successfully.
//
#define EVENTLOGMSG_SERVICE_STARTED      0x400003E8L

//
// MessageId: EVENTLOGMSG_SERVICE_STOPPED
//
// MessageText:
//
//  The service stopped successfully.
//
#define EVENTLOGMSG_SERVICE_STOPPED      0x400003E9L

//
// MessageId: EVENTLOGMSG_INFO_01
//
// MessageText:
//
//  InfoText: %1.
//
#define EVENTLOGMSG_INFO_01              0x400003EAL

 /*
    WARNING messages
 */
//
// MessageId: EVENTLOGMSG_WARNING_01
//
// MessageText:
//
//  WarningText: %1.
//
#define EVENTLOGMSG_WARNING_01           0x800007D0L

 /*
    ERROR messages
 */
//
// MessageId: EVENTLOGMSG_SETSERVICESTATUS_ERROR
//
// MessageText:
//
//  The service cannot report its status
//
#define EVENTLOGMSG_SETSERVICESTATUS_ERROR 0xC0000BB8L

//
// MessageId: EVENTLOGMSG_SERVICE_NOT_STARTED
//
// MessageText:
//
//  The service is not configured correctly
//
#define EVENTLOGMSG_SERVICE_NOT_STARTED  0xC0000BB9L

