/*************************************************************
 ****************    ===Picture Viewer===    *****************
 *************************************************************
            Copyright (c)1995,1996 Malcolm Taylor

 -> IMAGE.H
 -> The Image and ImageWindow classes that hold and display images.
*/

#ifndef _image_h
#define _image_h

#include <types.h>
#include <graphics.h>
#include <tws/scrolwin.h>

#define IMAGE_AUTO      0
#define IMAGE_TARGA     1
#define IMAGE_BITMAP    2

#define IMAGE_ERROR_UNKNOWN_FORMAT        1
#define IMAGE_ERROR_UNABLE_TO_OPEN_FILE   2
#define IMAGE_ERROR_LOADING_IMAGE         3

#define IMAGE_SAVE         0
#define IMAGE_SAVE_AS_TGA  1
#define IMAGE_SAVE_AS_BMP  2


                  // Holds and loads an image file.
class Image {
   public:
      Image(char *filename,int type=IMAGE_AUTO);
      ~Image();

      inline int GetWidth()
         { return width; }
      inline int GetHeight()
         { return height; }
      inline ViewBuffer *GetImage()
         { return image; }
      int DoError();    // Displays error information and returns TRUE if
                        // An error occured loading file.
      inline int GetType()
         { return type; }
      inline int isChanged()
         { return is_changed; }
      inline void SetChanged()
         { is_changed=TRUE; }
      inline void ClearChanged()
         { is_changed=FALSE; }

   protected:
      BYTE error,type,is_changed;
      WORD width;
      WORD height;
      ViewBuffer *image;
};

                  // Views an image file.
class ImageWindow:public ScrollingWindow {
   public:
      ImageWindow(int x,int y,char *filename,Image *i);
      ~ImageWindow();

   protected:
      void PaintWindow(int,int,int,int);
      void SysBox();
      void DocSave();
      void DocSaveAsTGA();
      void DocSaveAsBMP();

      Image *image;
      char *fname;
      int ow,oh;

      DECLARE_RESPONSE_TABLE;
};



#endif
