/*************************************************************
 ****************    ===Picture Viewer===    *****************
 *************************************************************
            Copyright (c)1995,1996 Malcolm Taylor

 -> IMAGE.H
 -> The Image and ImageWindow classes that hold and display images.
*/

#include "image.h"
#include <stdio.h>
#include <tws/message.h>
#include <tws/filedlg.h>

char *image_errors[]={
   "No error.",
   "Unknown image format. Unable to load image.",
   "Unable to open file",
   "Error while loading image file."
};

Image::Image(char *filename,int t)
   :image(NULL)
   ,width(0)
   ,height(0)
   ,error(0)
   ,type(t)
   ,is_changed(FALSE)
{
   FILE *fp;
   int f;
   BYTE r,g,b,*tmp;

   if(type==IMAGE_AUTO)
   {
      char magic[4];
      if(strstr(filename,".tga") || strstr(filename,".TGA"))
         type=IMAGE_TARGA;
      else 
      {
         fp=fopen(filename,"rb");
         if(fp==NULL)
         {
            error=IMAGE_ERROR_UNABLE_TO_OPEN_FILE;
            return;
         }
         magic[0]=fgetc(fp);
         magic[1]=fgetc(fp);
         magic[2]=fgetc(fp);
         fclose(fp);
         if(magic[0]=='B' && magic[1]=='M')
            type=IMAGE_BITMAP;
      }
      if(type==IMAGE_AUTO)
      {
         fclose(fp);
         error=IMAGE_ERROR_UNKNOWN_FORMAT;
         return;
      }
   }
   switch (type) {
      case IMAGE_TARGA:
         fp=fopen(filename,"rb");
         if(fp==NULL)
         {
            error=IMAGE_ERROR_UNABLE_TO_OPEN_FILE;
            return;
         }
         image=LoadTGA(fp);
         width=image->width;
         height=image->height;
         fclose(fp);
         break;
      case IMAGE_BITMAP:
         BYTE BMPheader[55];
         fp=fopen(filename,"rb");
         if(fp==NULL)
         {
            error=IMAGE_ERROR_UNABLE_TO_OPEN_FILE;
            return;
         }
         image=LoadBMP(fp);
         width=image->width;
         height=image->height;
         fclose(fp);
         break;
   }
}

Image::~Image()
{
   if(image!=NULL)
      DeleteBuffer(image);
}

int
Image::DoError()
{
   if(error)
   {
      char *estr=image_errors[error];
      MessageBox(estr,"Image Loader Error").Run();
      return TRUE;
   }
   else  
      return FALSE;
}


DEFINE_RESPONSE_TABLE(ImageWindow,ScrollingWindow)
   E_BUTTONUP(ID_SYSBOX,SysBox)
   E_DOCUMENT(IMAGE_SAVE,DocSave)
   E_DOCUMENT(IMAGE_SAVE_AS_TGA,DocSaveAsTGA)
   E_DOCUMENT(IMAGE_SAVE_AS_BMP,DocSaveAsBMP)
END_RESPONSE_TABLE

ImageWindow::ImageWindow(int x,int y,char *filename,Image *i)
   :ScrollingWindow(NULL,filename,x,y,MIN(x+i->GetWidth()+SIZING_BORDER_WIDTH*2,ws.GetDeskWidth()),MIN(y+i->GetHeight()+SIZING_BORDER_WIDTH*2+CAPTION_HEIGHT-1,ws.GetDeskHeight()),WA_VISABLE | WA_CAPTION | WA_SIZEABLE | WA_BORDER | WA_SAVEAREA | WA_SYSBOX)
   ,image(i)
   ,fname(strdup(filename))
{
   isDoc=TRUE;
   oh=h;
   ow=w;
   SetClientArea(SIZING_BORDER_WIDTH,SIZING_BORDER_WIDTH+CAPTION_HEIGHT,w-SIZING_BORDER_WIDTH-1,h-SIZING_BORDER_WIDTH-1);
   ChangeSize(i->GetWidth(),i->GetHeight());
   Paint();
   RefreshWindow();
   parent->SetFocus(this);
}

ImageWindow::~ImageWindow()
{
   delete image;
   free(fname);
}

void
ImageWindow::PaintWindow(int x1,int y1,int x2,int y2)
{
   ViewBuffer *temp;
   int xa,ya,xb,yb;

   ScrollingWindow::PaintWindow(x1,y1,x2,y2);
   x1=MAX(x1,0);
   y1=MAX(y1,0);
   x2=MIN(x2,w-1);
   y2=MIN(y2,h-1);

   if(ow!=w || oh!=h)
      ChangeSize(image->GetWidth(),image->GetHeight());
   ow=w;
   oh=h;

   minw+=50;
   minh+=50;
   
   temp=SubBuffer(wnd,x1,y1,x2,y2);
   xa=MAX(x1-cx1,0);
   ya=MAX(y1-cy1,0);
   if(vslider)
      xb=MIN(x2,cx2-16);
   else
      xb=MIN(x2,cx2);
   if(hslider)
      yb=MIN(y2,cy2-16);
   else
      yb=MIN(y2,cy2);
   xb=MIN(xb-cx1,image->GetWidth()-xo-1);
   yb=MIN(yb-cy1,image->GetHeight()-yo-1);
   UniBitBlt(temp,MAX(0,cx1-x1),MAX(0,cy1-y1),image->GetImage(),xo+xa,yo+ya,xo+xb,yo+yb);
   DeleteBuffer(temp);
}

void
ImageWindow::SysBox()
{
   ws.QueueEvent(parent,event(W_REMOVE_CHILD,(int)this));
}

void
ImageWindow::DocSave()
{
   FILE *fp;
   if(!image->isChanged())
      return;
   switch (image->GetType()) {
      case IMAGE_BITMAP:
         fp=fopen(fname,"wb");
         SaveBMP(image->GetImage(),fp);
         fclose(fp);
         break;
      case IMAGE_TARGA:
         fp=fopen(fname,"wb");
         SaveTGA(image->GetImage(),fp);
         fclose(fp);
         break;
   }
   image->ClearChanged();
}

void
ImageWindow::DocSaveAsTGA()
{
   FILE *fp;
   char *filename=FileDlg("Save As Targa",fname).Run();

   if(filename)
   {
      fp=fopen(filename,"wb");
      if(fp==NULL)
      {
         MessageBox("File Error","Unable to open file.").Run();
         return;
      }
      if(!SaveTGA(image->GetImage(),fp))
      {
         MessageBox("File Error","Error while save image to file.").Run();
         return;
      }
      fclose(fp);
      free(fname);
      fname=filename;
      image->ClearChanged();
   }
}

void
ImageWindow::DocSaveAsBMP()
{
   FILE *fp;
   char *filename=FileDlg("Save As Bitmap",fname).Run();
   if(filename)
   {
      fp=fopen(filename,"wb");
      if(fp==NULL)
      {
         MessageBox("File Error","Unable to open file.").Run();
         return;
      }
      if(!SaveBMP(image->GetImage(),fp))
      {
         MessageBox("File Error","Error while save image to file.").Run();
         return;
      }
      fclose(fp);
      free(fname);
      fname=filename;
      image->ClearChanged();
   }
}

