/*************************************************************
 ***************    ===The Window System===    ***************
 *************************************************************
            Copyright (c)1995,1996 Malcolm Taylor

 -> SB.H
 -> Definitions for structures and declarations of functions.
*/

#ifndef _sb_h
#define _sb_h

#include <types.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SOUND_BLASTER      0
#define SOUND_BLASTER_PRO  1
#define SOUND_BLASTER_16   3

#define SAMPLE_INVALID     -1
#define SAMPLE_8BIT        0
#define SAMPLE_16BIT       1

typedef struct {
   int type;
   union {
      char *b;
      short *w;
   } sample;
   int frequency;
   int length;
   int volume,pan;
} SOUND_SAMPLE;

int InitialiseSound(int type,int port,int dma_num,int hdma_num,int int_num);
                              /* Allocates all locked memory and initialises
                                 the sound card. */
void DeInitialiseSound();
void SetSampleRate(int rate); /* Sets the sample rate in Hz */
void StartPlaying();          /* Starts playing */
void StopPlaying();           /* Stops playing */

SOUND_SAMPLE *LoadWaveFile(const char *filename);
                              /* Loads a wave file in */
void DeleteSample(SOUND_SAMPLE *smp);
                              /* Deletes the sample smp */
void PlaySample(SOUND_SAMPLE *sample);
                              /* Plays the sample immediately */
void PlaySampleF(SOUND_SAMPLE *sample,int frequency);
void PlaySampleFV(SOUND_SAMPLE *sample,int frequency,int volume);
void PlaySampleFVP(SOUND_SAMPLE *sample,int frequency,int volume,int pan);
void QueueSample(SOUND_SAMPLE *sample,int frequency,int volume,int pan,int delay);

void StopAllSamples();        /* Clears all playing samples */
void StopSample(SOUND_SAMPLE *sample);
                              /* Stops all instances of sample */
SOUND_SAMPLE *ChangeSampleFrequency(SOUND_SAMPLE *sample,int new_frequency);
                              /* Resamples sample (with interpolation) */
DWORD GetSBTicks();           /* Returns the SB interrupt ticks */


#ifdef __cplusplus
}
#endif



#endif
