/*************************************************************
 ***************    ===The Window System===    ***************
 *************************************************************
				Copyright (c)1995,1996 Malcolm Taylor

 -> EDIT.H
 -> EditText class for a text edit control.
*/

#ifndef _edit_h
#define _edit_h

#include <tws/window.h>

#define EDIT_TYPE_TEXT        0
#define EDIT_TYPE_FORCE_UPPER 1
#define EDIT_TYPE_FORCE_LOWER 2
#define EDIT_TYPE_NUMBER      3
#define EDIT_TYPE_NEG_NUM     4
#define EDIT_TYPE_FLOAT_NUM   5

class EditText:public Window {
	public:
		EditText(Window *parent,ControlID ID,const char *title,int n,int x,int y,int l,int t=EDIT_TYPE_TEXT);
		~EditText();

		void SetText(const char *text);
		char *GetText() {return Text;}
		void Select();
		inline void SetType(int n) {Type=n;}

	protected:
		void Focus();
		void UnFocus();
		void PaintWindow(int x1,int y1,int x2,int y2);
		void Timer();
		void DrawCursor();
		void LButtonDown(int,int,int);
		void LButtonUp(int,int,int);
		void MouseMove(int,int,int,int);

		int first_pos,curs_pos,max,length,Type,block_start,block_end,dir;
		char *Text;
		char *Title;
		ControlID editID;
		BOOL Insert,isSelected,isCursorShowing,isMouse;

		DECLARE_RESPONSE_TABLE;
};

#endif


