/*************************************************************
 ***************    ===The Window System===    ***************
 *************************************************************
				Copyright (c)1995,1996 Malcolm Taylor

 -> BUTTON.H
 -> Button, TextButton and IconButton classes.
*/

#ifndef _button_h
#define _button_h

#include <tws/window.h>
#include <graphics.h>
#include <string.h>

#define E_BUTTONDOWN(ID,function) \
	if(ev->Type==W_NOTIFY && ev->p1==ID && ev->p2==1001) \
	{ \
		function(); \
		return TRUE; \
	}

#define E_BUTTONUP(ID,function) \
	if(ev->Type==W_NOTIFY && ev->p1==ID && ev->p2==1000) \
	{ \
		function(); \
		return TRUE; \
	}

#define E_DOUBLECLICK(ID,function) \
	if(ev->Type==W_NOTIFY && ev->p1==ID && ev->p2==1002) \
	{ \
		function(); \
		return TRUE; \
	}

/*==========================================================*
 *    The Basic button class with no picture or text on it  *
 *==========================================================*/

class BasicButton:public Window {
	public:
		BasicButton(Window *parent,ControlID ID,int x1,int y1,int x2,int y2);

		void Select();

	protected:
		virtual void PaintWindow(int x1,int y1,int x2,int y2);
		void LButtonDown(int x,int y,int key_stat,int timer);
		void LButtonUp(int x,int y,int key_stat);
		void MouseMove(int x,int y,int key_stat,int but_stat);
		void MoveOutside(int x,int y,int key_stat,int but_stat);
		virtual void Focus();
		virtual void UnFocus();

		BOOL isDown,isPushed,isInFocus;
		ControlID butID;

		DECLARE_RESPONSE_TABLE;
};


/*==========================================================*
 *              A button with text on it                    *
 *==========================================================*/

class TextButton:public BasicButton {
	public:
		TextButton(Window *parent,ControlID ID,int x1,int y1,int x2,int y2,const char *text);
		~TextButton();

	protected:
		virtual void PaintWindow(int x1,int y1,int x2,int y2);

		char *Text;
};


/*==========================================================*
 *             A button with an icon on it                  *
 *==========================================================*/

class IconButton:public BasicButton {
	public:
		IconButton(Window *parent,ControlID ID,int x1,int y1,int x2,int y2,ViewBuffer *icn)
			:BasicButton(parent,ID,x1,y1,x2,y2)
			,Icon(icn)
			,isOwner(FALSE)
			{}
		IconButton(Window *parent,ControlID ID,int x1,int y1,int x2,int y2,const BYTE *data,
																							int w,int h,const BYTE *colours);
		~IconButton();

		void ChangeIcon(ViewBuffer *NewIcon);

	protected:
		virtual void PaintWindow(int x1,int y1,int x2,int y2);

		ViewBuffer *Icon;
		BOOL isOwner;
};


#endif

