/*************************************************************
 ***************    ===Graphics Library===    ****************
 *************************************************************
      Copyright (c)1995 Grafik Software by Malcolm Taylor

 -> GRAPHICS.H
 -> Graphical function declarations.
*/

#ifndef _graphics_h
#define _graphics_h

#include <video.h>
#include <string.h>
#include <stdio.h>

#define IS_BUFFER_OWNER 0x1000000

typedef struct {
   int colour_depth;       /* The depth of colour (8,15,16,24bits) */
   int width,height;       /* The size of the writable area */
   int scan_length;        /* Actual length in bytes of each line */
   int aspect;             /* The aspect ratio *256 */
   void *base;             /* The base address of buffer */
   WORD *dummy;            /* Dummy place holder */
} ViewBuffer;

#ifdef __cplusplus
extern "C" {
#endif

#define  FONT_MAGIC_NUMBER  0x19590214L

typedef struct {
    int magic;             /* magic number */
    int bitmapsize;        /* size of the bitmap */
    SWORD width;           /* font width */
    SWORD height;          /* font height */
    WORD min_char;         /* lowest character code in font */
    WORD max_char;         /* highest character code in font */
    SWORD isfixed;         /* is it a fixed font */
    SWORD internal;        /* is it a BIOS font */
    SWORD baseline;        /* baseline from top of font */
    SWORD und_width;       /* underline width (at bottom) */
    char name[16];         /* font file name */
    char family[16];       /* font family name */
} FONT_FILE_HEADER;

typedef struct {        
    SWORD width;           /* font width */
    SWORD height;          /* font height */
    WORD min_char;         /* lowest character code in font */
    WORD max_char;         /* highest character code in font */
    SWORD baseline;        /* baseline from top of font */
    SWORD und_width;       /* underline width (at bottom) */
    BYTE isfixed;          /* is it a fixed font */
    BYTE **chars;          /* list of character data pointers */
    SWORD *widths;         /* list of character widths */
    BYTE *data;            /* bitmap data */
} FONT;

FONT *LoadFont(const char *name);
void DeleteFont(FONT *font);
void WriteChar(ViewBuffer *buf,int x,int y,int col,const FONT *font,int ch);
void WriteText(ViewBuffer *buf,int x,int y,int col,const FONT *font,const char *text);
int StringWidth(const char *text,const FONT *font);
#define CharWidth(c,f) (((c)>=(f)->min_char && (c)<=(f)->max_char)?((f)->widths[(c)-(f)->min_char]):((f)->width))

extern BYTE Halftone4x4[];
extern BYTE XLateRed[],XLateGreen[],XLateBlue[];

#define MAKE_8BIT_COLOUR(r,g,b) (XLateRed[r] + XLateGreen[g] + XLateBlue[b])
#define MAKE_15BIT_COLOUR(r,g,b) (((WORD)((r)&0xf8))<<7) | (((WORD)((g)&0xf8))<<2) | ((WORD)((b)>>3))

ViewBuffer *NewBuffer(int width,int height);
ViewBuffer *NewBuffer24(int width,int height);
ViewBuffer *SubBuffer(const ViewBuffer *buf,int x1,int y1,int x2,int y2);
void DeleteBuffer(ViewBuffer *buf);
ViewBuffer *BuildBuffer(const BYTE *data,int w,int h,const BYTE *pal);

void Box(ViewBuffer *buf,int x1,int y1,int x2,int y2,int c);
void RGBBox(ViewBuffer *buf,int x1,int y1,int x2,int y2,int r,int g,int b);
void Rect(ViewBuffer *buf,int x1,int y1,int x2,int y2,int c);
void RGBRect(ViewBuffer *buf,int x1,int y1,int x2,int y2,int r,int g,int b);
void Line(ViewBuffer *buf,int x1,int y1,int x2,int y2,int c);
void RGBLine(ViewBuffer *buf,int x1,int y1,int x2,int y2,int r,int g,int b);
void HLine(ViewBuffer *buf,int x1,int x2,int y,int c);
void RGBHLine(ViewBuffer *buf,int x1,int x2,int y,int r,int g,int b);
void VLine(ViewBuffer *buf,int x,int y1,int y2,int c);
void RGBVLine(ViewBuffer *buf,int x,int y1,int y2,int r,int g,int b);
void Pixel(ViewBuffer *buf,int x,int y,int c);
void RGBPixel(ViewBuffer *buf,int x,int y,int r,int g,int b);
void Circle(ViewBuffer *buf,int x,int y,int rad,int c);
void RGBCircle(ViewBuffer *buf,int x,int y,int rad,int r,int g,int b);
void FillCircle(ViewBuffer *buf,int x,int y,int rad,int c);
void RGBFillCircle(ViewBuffer *buf,int x,int y,int rad,int r,int g,int b);
void Polygon(ViewBuffer *buf,int npts,int *x,int *y,int c);
void RGBPolygon(ViewBuffer *buf,int npts,int *x,int *y,int r,int g,int b);
void PolyLine(ViewBuffer *buf,int n,int *x,int *y,int c);
void RGBPolyLine(ViewBuffer *buf,int n,int *x,int *y,int r,int g,int b);
void BitBltToScreen24(const ViewBuffer *from,int x,int y);

#define XOR_WRITE 0x100
void ScreenRectangle(int x1,int y1,int x2,int y2,int col);
void ScreenBox(int x1,int y1,int x2,int y2,int col);
void ScreenRGBPixel(int x,int y,int r,int g,int b);

void UniBitBlt(ViewBuffer *to,int x,int y,const ViewBuffer *from,int x1,int y1,int x2,int y2);
void BitBlt(ViewBuffer *to,int x,int y,const ViewBuffer *from,int x1,int y1,int x2,int y2);
void BitBltTransparent(ViewBuffer *to,int x,int y,const ViewBuffer *from,int x1,int y1,int x2,int y2);
void BltToScreen(const ViewBuffer *from,int x,int y);
void BltFromScreen(ViewBuffer *to,int x,int y);
void BltToScreenTransparent(const ViewBuffer *from,int x,int y);
void BitBltToScreen24(const ViewBuffer *from,int x,int y);

void SetupBasicColour(int r,int g,int b);
int AllocColour(int r,int g,int b);
void FreeColour(int c);
void Fill4BitXlateTable();

ViewBuffer *LoadBMP(FILE *fp);
ViewBuffer *LoadTGA(FILE *fp);
int SaveBMP(ViewBuffer *buf,FILE *fp);
int SaveTGA(ViewBuffer *buf,FILE *fp);

#ifdef __cplusplus
}
#endif


#endif
