/* -*- coding: cp852 -*-

  DJGPP Socket Wrapper for Microsoft Network Client  
  written by Tomasz Zbroek (2007/2008) / UPOS System Sp. z o.o.
  Released to the Public Domain.

*/

#include <fcntl.h>
#include <dos.h>
#include <dpmi.h>
#include <go32.h>
#include <sys/farptr.h>
#include <string.h>
#include <sys/movedata.h>
#include <libc/dosio.h>

#include "basmac.h"
#include "locater.h"
#include "result.h"

static int hDriver = 0;
static const char szDriverName[] = "TCPDRV$";
struct SDriver sDrvBind = {0,0,0,0,0,0,0,0,0};
struct SDriver sDrvUnbind = {0,0,0,0,0,0,0,0,0};

/****************************************************************/
/** Open MS Client driver
 */
bool LocaterOpen()
{
  int nRes;

  // open driver file
  nRes = _dos_open(szDriverName, O_RDONLY, &hDriver);
  if(nRes)
    {
      return FALSE;
    }

  return TRUE;
}

/****************************************************************/
/** Close MS Client driver
 */
bool LocaterClose()
{
  int nRes;

  // close driver file
  nRes = _dos_close(hDriver);
  if(nRes)
    {
      return FALSE;
    }

  return TRUE;
}

/****************************************************************/
/** Bind to MS Client
 */
bool LocaterBind(const char *i_pName, dword *o_pProcAddr, word *o_pResult) 
{
  int nRes;
  __dpmi_regs sRegs;

  sDrvBind.yField0 = 2;
  memcpy(&sDrvBind.wField2, i_pName, 2);

  // copy PM buffer to RM area
  dosmemput(&sDrvBind, sizeof(sDrvBind), __tb);

  // IOCTL Receive Control Data from Char Device
  sRegs.x.ax = 0x4402;
  sRegs.x.bx = (short) hDriver;
  sRegs.x.cx = 25; 
  sRegs.x.ds = __tb_segment;
  sRegs.x.dx = __tb_offset;
  nRes = __dpmi_int(0x21, &sRegs);
  if(nRes == -1)
    {
      return FALSE;
    }
  if(sRegs.x.flags & 1)
    {
      return FALSE;
    }
  
  // copy RM buffer to PM buffer
  dosmemget(__tb, sizeof(sDrvBind), &sDrvBind);
  
  *o_pProcAddr = sDrvBind.dwField3; // MS Client procedure

  // result
  *o_pResult = MAKEWORD(sDrvBind.yField1, 0);

  return TRUE;
}

/****************************************************************/
/** Unbind from MS Client
 */
bool LocaterUnbind(const char *i_pName, word *o_pResult) 
{
  int nRes;
  __dpmi_regs sRegs;
  //dword dwPhysAddr;

  sDrvUnbind.yField0 = 3;
  memcpy(&sDrvUnbind.wField2, i_pName, 2);
  
  // copy PM buffer to RM area
  //dwPhysAddr = sDosBuf.rm_segment * 16 + sDosBuf.rm_offset;
  dosmemput(&sDrvUnbind, sizeof(sDrvUnbind), __tb);

  // IOCTL Receive Control Data from Char Device
  sRegs.x.ax = 0x4402;
  sRegs.x.bx = (short) hDriver;
  sRegs.x.cx = 25; 
  sRegs.x.ds = __tb_segment;
  sRegs.x.dx = __tb_offset;
  nRes = __dpmi_int(0x21, &sRegs);
  if(nRes == -1)
    {
      return FALSE;
    }
  if(sRegs.x.flags & 1)
    {
      return FALSE;
    }
  
  // copy RM buffer to PM buffer
  dosmemget(__tb, sizeof(sDrvUnbind), &sDrvUnbind);
  
  // result
  *o_pResult = MAKEWORD(sDrvUnbind.yField1, 0);

  return TRUE;
}

/****************************************************************/
/** Send command to MS Client
 */
int LocaterSend(struct SCommand *pCmd, word *o_pErrNo)
{
  int nRes = 0;
  __dpmi_regs sRegs;
  word wValue;
  const int nCmdOffset = 2;
  const int nErrOffset = 34;

  pCmd->wResOffset = __tb_offset;
  pCmd->wResSegment = __tb_segment;
  pCmd->wErrOffset = __tb_offset + nErrOffset;
  pCmd->wErrSegment = __tb_segment;
 
  // in original (RM) wCodeSegment should contain cs register 
  pCmd->wCodeSegment = 0;

  // copy PM buffer to RM area
  dosmemput(pCmd, 32, __tb + nCmdOffset);

  // clear place for result
  _farpokew(_dos_ds, __tb, 0);
  // clear place for errno
  _farpokew(_dos_ds, __tb + nErrOffset, 0);

  // run MS Client procedure
  memset(&sRegs, 0, sizeof(sRegs));
  sRegs.x.es = __tb_segment;
  sRegs.x.bx = __tb_offset + nCmdOffset;
  sRegs.x.ip = LOWORD(sDrvBind.dwField3);
  sRegs.x.cs = HIWORD(sDrvBind.dwField3);
  nRes = __dpmi_simulate_real_mode_procedure_retf(&sRegs);
  if(nRes == -1)
    {
      *o_pErrNo = eErrNo_ProcedureExecute;
      return -1;
    }

  // copy RM buffer to PM buffer
  dosmemget(__tb + 12, 22, ((byte *) pCmd) + 10);
  
  // get errno
  wValue = _farpeekw(_dos_ds, __tb);
  *o_pErrNo = wValue;

  // get result
  wValue = _farpeekw(_dos_ds, __tb + nErrOffset);  
  nRes = wValue;

  return nRes;
}
