/*
 * This small program shows how to use `keyboard_..' functions provided in
 * "keyboard.s". It is nice to have a look at "keyboard.h" also: SCAN_..
 * constants are defined there... :)  Have fun. Martynas.
 *
 */

#include <stdio.h>
#include "keyboard.h"

#define ON  1
#define OFF 0

main()
{
  char buffer[64];

  /* Install the keyboard handler and check for errors: */

  if (keyboard_init())
  {
    printf("DPMI error\n");
    exit(-1);
  }


  printf("Press both shifts to continue...\n");
  fflush(stdout);
  
  /* Wait for both shifts to be pressed */

  while (!(keyboard_key_down(SCAN_LSHIFT) &&
           keyboard_key_down(SCAN_RSHIFT) ));

  printf("Are you running Windoze, OS/2 or any other multitasking OS? (y/n):");
  fflush(stdout);
  scanf("%c", buffer);
  
  /* This is not because keyboard_unchain would not work under Win or OS/2 */
  /* This is just because they would trap the ctrl-alt-del combination :)  */
  
  if (buffer[0] != 'y' && buffer[0] != 'Y')
  {
    /* Have the keyboard all for ourselves: */
    keyboard_chain(OFF);

    printf("then press Ctrl-Alt-Del to continue :)\n");
    fflush(stdout);
  
    /* Wait for the magic combination to be pressed: */

    while (!(keyboard_key_down(SCAN_CTRL) &&
  	     keyboard_key_down(SCAN_ALT)  &&
             keyboard_key_down(SCAN_DEL) ));

    printf("see?.. nothing to be afraid of..\n");
    fflush(stdout);

    /* Let BIOS or whatever process the keyboard after us: */
    keyboard_chain(ON);
  }

  printf("You can still use getkey() or scanf() etc., enter your name: ");
  fflush(stdout);
  scanf("%s", buffer);
  printf("you entered `%s'\n", buffer);

  /* Uninstall the handler: */

  keyboard_close();
}

