/**
 ** x11keys.h ---- Keyboard Translation Table
 **
 ** Copyright (C) 2006 Mariano Alvarez Fernandez
 ** [e-mail: malfer@telefonica.net]
 **
 ** This file is part of the GRX graphics library.
 **
 ** The GRX graphics library is free software; you can redistribute it
 ** and/or modify it under some conditions; see the "copying.grx" file
 ** for details.
 **
 ** This library is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 **
 ** Contributions by:
 ** 211215 M.Alvarez, better keycode conversion, using a table 
 **                   for every state instead of a big table
 **/

#ifndef _X11KEYS_H_
#define _X11KEYS_H_

typedef struct {
  unsigned short key;
  KeySym keysym;
} KeyEntry;

static KeyEntry _KTMod1[] = { // state == Mod1Mask
  { GrKey_Alt_0                , XK_0 },
  { GrKey_Alt_1                , XK_1 },
  { GrKey_Alt_2                , XK_2 },
  { GrKey_Alt_3                , XK_3 },
  { GrKey_Alt_4                , XK_4 },
  { GrKey_Alt_5                , XK_5 },
  { GrKey_Alt_6                , XK_6 },
  { GrKey_Alt_7                , XK_7 },
  { GrKey_Alt_8                , XK_8 },
  { GrKey_Alt_9                , XK_9 },
  { GrKey_Alt_A                , XK_a },
  { GrKey_Alt_At               , XK_at },
  { GrKey_Alt_B                , XK_b },
  { GrKey_Alt_Backquote        , XK_quoteright },
  { GrKey_Alt_Backslash        , XK_backslash },
  { GrKey_Alt_Backspace        , XK_BackSpace },
  { GrKey_Alt_C                , XK_c },
  { GrKey_Alt_Center           , XK_KP_Begin },
  { GrKey_Alt_Comma            , XK_comma },
  { GrKey_Alt_D                , XK_d },
  { GrKey_Alt_Dash             , XK_minus },
  { GrKey_Alt_Delete           , XK_Delete },
  { GrKey_Alt_Delete           , XK_KP_Delete },
  { GrKey_Alt_Down             , XK_Down },
  { GrKey_Alt_Down             , XK_KP_Down },
  { GrKey_Alt_E                , XK_e },
  { GrKey_Alt_End              , XK_End },
  { GrKey_Alt_End              , XK_KP_End },
  { GrKey_Alt_Enter            , XK_KP_Enter },
  { GrKey_Alt_Equals           , XK_equal },
  { GrKey_Alt_Escape           , XK_Escape },
  { GrKey_Alt_F                , XK_f },
  { GrKey_Alt_F1               , XK_F1 },
  { GrKey_Alt_F2               , XK_F2 },
  { GrKey_Alt_F3               , XK_F3 },
  { GrKey_Alt_F4               , XK_F4 },
  { GrKey_Alt_F5               , XK_F5 },
  { GrKey_Alt_F6               , XK_F6 },
  { GrKey_Alt_F7               , XK_F7 },
  { GrKey_Alt_F8               , XK_F8 },
  { GrKey_Alt_F9               , XK_F9 },
  { GrKey_Alt_F10              , XK_F10 },
  { GrKey_Alt_F11              , XK_F11 },
  { GrKey_Alt_F12              , XK_F12 },
  { GrKey_Alt_G                , XK_g },
  { GrKey_Alt_H                , XK_h },
  { GrKey_Alt_Home             , XK_Home },
  { GrKey_Alt_Home             , XK_KP_Home },
  { GrKey_Alt_I                , XK_i },
  { GrKey_Alt_Insert           , XK_Insert },
  { GrKey_Alt_Insert           , XK_KP_Insert },
  { GrKey_Alt_J                , XK_j },
  { GrKey_Alt_K                , XK_k },
  { GrKey_Alt_KPMinus          , XK_KP_Subtract },
  { GrKey_Alt_KPPlus           , XK_KP_Add },
  { GrKey_Alt_KPSlash          , XK_KP_Divide },
  { GrKey_Alt_KPStar           , XK_KP_Multiply },
  { GrKey_Alt_KPStar           , XK_multiply },
  { GrKey_Alt_L                , XK_l },
  { GrKey_Alt_LAngle           , XK_less },
  { GrKey_Alt_LBrace           , XK_braceleft },
  { GrKey_Alt_LBracket         , XK_bracketleft },
  { GrKey_Alt_Left             , XK_KP_Left },
  { GrKey_Alt_Left             , XK_Left },
  { GrKey_Alt_M                , XK_m },
  { GrKey_Alt_N                , XK_n },
  { GrKey_Alt_O                , XK_o },
  { GrKey_Alt_P                , XK_p },
  { GrKey_Alt_PageDown         , XK_Next },
  { GrKey_Alt_PageDown         , XK_KP_Next },
  { GrKey_Alt_PageUp           , XK_Prior },
  { GrKey_Alt_PageUp           , XK_KP_Prior },
  { GrKey_Alt_Period           , XK_period },
  { GrKey_Alt_Pipe             , XK_bar },
  { GrKey_Alt_Q                , XK_q },
  { GrKey_Alt_Quote            , XK_quoteleft },
  { GrKey_Alt_R                , XK_r },
  { GrKey_Alt_RAngle           , XK_greater },
  { GrKey_Alt_RBrace           , XK_braceright },
  { GrKey_Alt_RBracket         , XK_bracketright },
  { GrKey_Alt_Return           , XK_Return },
  { GrKey_Alt_Right            , XK_KP_Right },
  { GrKey_Alt_Right            , XK_Right },
  { GrKey_Alt_S                , XK_s },
  { GrKey_Alt_Semicolon        , XK_semicolon },
  { GrKey_Alt_Slash            , XK_slash },
  { GrKey_Alt_T                , XK_t },
  { GrKey_Alt_Tab              , XK_Tab },
  { GrKey_Alt_U                , XK_u },
  { GrKey_Alt_Up               , XK_KP_Up },
  { GrKey_Alt_Up               , XK_Up },
  { GrKey_Alt_V                , XK_v },
  { GrKey_Alt_W                , XK_w },
  { GrKey_Alt_X                , XK_x },
  { GrKey_Alt_Y                , XK_y },
  { GrKey_Alt_Z                , XK_z },
  { GrKey_Alt_A                , XK_A },
  { GrKey_Alt_B                , XK_B },
  { GrKey_Alt_C                , XK_C },
  { GrKey_Alt_D                , XK_D },
  { GrKey_Alt_E                , XK_E },
  { GrKey_Alt_F                , XK_F },
  { GrKey_Alt_G                , XK_G },
  { GrKey_Alt_H                , XK_H },
  { GrKey_Alt_I                , XK_I },
  { GrKey_Alt_J                , XK_J },
  { GrKey_Alt_K                , XK_K },
  { GrKey_Alt_L                , XK_L },
  { GrKey_Alt_M                , XK_M },
  { GrKey_Alt_N                , XK_N },
  { GrKey_Alt_O                , XK_O },
  { GrKey_Alt_P                , XK_P },
  { GrKey_Alt_Q                , XK_Q },
  { GrKey_Alt_R                , XK_R },
  { GrKey_Alt_S                , XK_S },
  { GrKey_Alt_T                , XK_T },
  { GrKey_Alt_U                , XK_U },
  { GrKey_Alt_V                , XK_V },
  { GrKey_Alt_W                , XK_W },
  { GrKey_Alt_X                , XK_X },
  { GrKey_Alt_Y                , XK_Y },
  { GrKey_Alt_Z                , XK_Z },
  { GrKey_Alt_A                , XK_Greek_ALPHA },
  { GrKey_Alt_B                , XK_Greek_BETA },
  { GrKey_Alt_G                , XK_Greek_GAMMA },
  { GrKey_Alt_D                , XK_Greek_DELTA },
  { GrKey_Alt_E                , XK_Greek_EPSILON },
  { GrKey_Alt_Z                , XK_Greek_ZETA },
  { GrKey_Alt_H                , XK_Greek_ETA },
  { GrKey_Alt_U                , XK_Greek_THETA },
  { GrKey_Alt_I                , XK_Greek_IOTA },
  { GrKey_Alt_K                , XK_Greek_KAPPA },
  { GrKey_Alt_L                , XK_Greek_LAMBDA },
  { GrKey_Alt_M                , XK_Greek_MU },
  { GrKey_Alt_N                , XK_Greek_NU },
  { GrKey_Alt_J                , XK_Greek_XI },
  { GrKey_Alt_O                , XK_Greek_OMICRON },
  { GrKey_Alt_P                , XK_Greek_PI },
  { GrKey_Alt_R                , XK_Greek_RHO },
  { GrKey_Alt_S                , XK_Greek_SIGMA },
  { GrKey_Alt_T                , XK_Greek_TAU },
  { GrKey_Alt_Y                , XK_Greek_UPSILON },
  { GrKey_Alt_F                , XK_Greek_PHI },
  { GrKey_Alt_X                , XK_Greek_CHI },
  { GrKey_Alt_C                , XK_Greek_PSI },
  { GrKey_Alt_V                , XK_Greek_OMEGA },
  { GrKey_Alt_A                , XK_Greek_alpha },
  { GrKey_Alt_B                , XK_Greek_beta },
  { GrKey_Alt_G                , XK_Greek_gamma },
  { GrKey_Alt_D                , XK_Greek_delta },
  { GrKey_Alt_E                , XK_Greek_epsilon },
  { GrKey_Alt_Z                , XK_Greek_zeta },
  { GrKey_Alt_H                , XK_Greek_eta },
  { GrKey_Alt_U                , XK_Greek_theta },
  { GrKey_Alt_I                , XK_Greek_iota },
  { GrKey_Alt_K                , XK_Greek_kappa },
  { GrKey_Alt_L                , XK_Greek_lambda },
  { GrKey_Alt_M                , XK_Greek_mu },
  { GrKey_Alt_N                , XK_Greek_nu },
  { GrKey_Alt_J                , XK_Greek_xi },
  { GrKey_Alt_O                , XK_Greek_omicron },
  { GrKey_Alt_P                , XK_Greek_pi },
  { GrKey_Alt_R                , XK_Greek_rho },
  { GrKey_Alt_S                , XK_Greek_sigma },
  { GrKey_Alt_T                , XK_Greek_tau },
  { GrKey_Alt_Y                , XK_Greek_upsilon },
  { GrKey_Alt_F                , XK_Greek_phi },
  { GrKey_Alt_X                , XK_Greek_chi },
  { GrKey_Alt_C                , XK_Greek_psi },
  { GrKey_Alt_V                , XK_Greek_omega },
};

static KeyEntry _KTShift[] = { // state == ShiftMask
  { GrKey_BackTab              , XK_ISO_Left_Tab },
  { GrKey_Shift_Down           , XK_Down },
  { GrKey_Shift_End            , XK_End },
  { GrKey_Shift_F1             , XK_F1 },
  { GrKey_Shift_F2             , XK_F2 },
  { GrKey_Shift_F3             , XK_F3 },
  { GrKey_Shift_F4             , XK_F4 },
  { GrKey_Shift_F5             , XK_F5 },
  { GrKey_Shift_F6             , XK_F6 },
  { GrKey_Shift_F7             , XK_F7 },
  { GrKey_Shift_F8             , XK_F8 },
  { GrKey_Shift_F9             , XK_F9 },
  { GrKey_Shift_F10            , XK_F10 },
  { GrKey_Shift_F11            , XK_F11 },
  { GrKey_Shift_F12            , XK_F12 },
  { GrKey_Shift_Home           , XK_Home },
  { GrKey_Shift_Insert         , XK_Insert },
  { GrKey_Shift_Left           , XK_Left },
  { GrKey_Shift_PageDown       , XK_Next },
  { GrKey_Shift_PageUp         , XK_Prior },
  { GrKey_Shift_Right          , XK_Right },
  { GrKey_Shift_Up             , XK_Up },
};

static KeyEntry _KTVoid[] = { // state == 0
  { GrKey_Center               , XK_5 },
  { GrKey_Center               , XK_KP_Begin },
  { GrKey_Dash                 , XK_KP_Subtract },
  { GrKey_Delete               , XK_Delete },
  { GrKey_Delete               , XK_KP_Delete },
  { GrKey_Down                 , XK_Down },
  { GrKey_Down                 , XK_KP_Down },
  { GrKey_End                  , XK_End },
  { GrKey_End                  , XK_KP_End },
  { GrKey_F1                   , XK_F1 },
  { GrKey_F2                   , XK_F2 },
  { GrKey_F3                   , XK_F3 },
  { GrKey_F4                   , XK_F4 },
  { GrKey_F5                   , XK_F5 },
  { GrKey_F6                   , XK_F6 },
  { GrKey_F7                   , XK_F7 },
  { GrKey_F8                   , XK_F8 },
  { GrKey_F9                   , XK_F9 },
  { GrKey_F10                  , XK_F10 },
  { GrKey_F11                  , XK_F11 },
  { GrKey_F12                  , XK_F12 },
  { GrKey_Home                 , XK_Home },
  { GrKey_Home                 , XK_KP_Home },
  { GrKey_Insert               , XK_Insert },
  { GrKey_Insert               , XK_KP_Insert },
  { GrKey_Left                 , XK_Left },
  { GrKey_Left                 , XK_KP_Left },
  { GrKey_PageDown             , XK_Next },
  { GrKey_PageDown             , XK_KP_Next },
  { GrKey_PageUp               , XK_Prior },
  { GrKey_PageUp               , XK_KP_Prior },
  { GrKey_Plus                 , XK_KP_Add },
  { GrKey_Print                , XK_Print },
  { GrKey_Right                , XK_Right },
  { GrKey_Right                , XK_KP_Right },
  { GrKey_Up                   , XK_Up },
  { GrKey_Up                   , XK_KP_Up },
};

static KeyEntry _KTControl[] = { // state == ControlMask
  { GrKey_Control_At           , XK_at },
  { GrKey_Control_Center       , XK_5 },
  { GrKey_Control_Center       , XK_KP_Begin },
  { GrKey_Control_Delete       , XK_Delete },
  { GrKey_Control_Delete       , XK_KP_Delete },
  { GrKey_Control_Down         , XK_Down },
  { GrKey_Control_Down         , XK_KP_Down },
  { GrKey_Control_End          , XK_End },
  { GrKey_Control_End          , XK_KP_End },
  { GrKey_Control_F1           , XK_F1 },
  { GrKey_Control_F2           , XK_F2 },
  { GrKey_Control_F3           , XK_F3 },
  { GrKey_Control_F4           , XK_F4 },
  { GrKey_Control_F5           , XK_F5 },
  { GrKey_Control_F6           , XK_F6 },
  { GrKey_Control_F7           , XK_F7 },
  { GrKey_Control_F8           , XK_F8 },
  { GrKey_Control_F9           , XK_F9 },
  { GrKey_Control_F10          , XK_F10 },
  { GrKey_Control_F11          , XK_F11 },
  { GrKey_Control_F12          , XK_F12 },
  { GrKey_Control_Home         , XK_Home },
  { GrKey_Control_Home         , XK_KP_Home },
  { GrKey_Control_Insert       , XK_Insert },
  { GrKey_Control_Insert       , XK_KP_Insert },
  { GrKey_Control_KPDash       , XK_KP_Subtract },
  { GrKey_Control_KPPlus       , XK_KP_Add },
  { GrKey_Control_KPSlash      , XK_slash },
  { GrKey_Control_KPStar       , XK_multiply },
  { GrKey_Control_Left         , XK_Left },
  { GrKey_Control_Left         , XK_KP_Left },
  { GrKey_Control_PageDown     , XK_Next },
  { GrKey_Control_PageDown     , XK_KP_Next },
  { GrKey_Control_PageUp       , XK_Prior },
  { GrKey_Control_PageUp       , XK_KP_Prior },
  { GrKey_Control_Right        , XK_Right },
  { GrKey_Control_Right        , XK_KP_Right },
  { GrKey_Control_Up           , XK_Up },
  { GrKey_Control_Up           , XK_KP_Up },
};

#endif
