/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: _fputwc.c,v 1.1 1996/07/13 20:06:10 jack Exp $ */

#include <stdio.h>
#include <wchar.h>
#include <wcprvt.h>

wint_t
__fputwc (wint_t wc, FILE *fp)
{
  size_t bytes = sizeof (wchar_t);
  int c;

  while (bytes-- > 0)
    {
      c = (wc >> (bytes * 8)) & 0x000000ffU;
      c = fputc (c, fp);
      if (c == EOF)
	return WEOF;
    }

  return (wint_t) wc;
}
