/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: wctype.h,v 1.3 1996/10/27 13:23:30 jack Exp $ */

#ifndef __wctype_h__
#define __wctype_h__

/* for wchar_t */
#include <stddef.h>

#ifndef __wint_t_defined__
#define __wint_t_defined__
typedef int wint_t;
#endif

#ifndef __wctrans_t_defined__
#define __wctrans_t_defined__
typedef int wctrans_t;
#endif

#ifndef __wctype_t_defined__
#define __wctype_t_defined__
typedef int wctype_t;
#endif

#ifndef WEOF
#define WEOF ((wint_t) (-1L))
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* functions */
extern int iswalnum (wint_t wc);
extern int iswalpha (wint_t wc);
extern int iswascii (wint_t wc);
extern int iswcntrl (wint_t wc);
extern int iswctype (wint_t wc, wctype_t type);
extern int iswdigit (wint_t wc);
extern int iswgraph (wint_t wc);
extern int iswlower (wint_t wc);
extern int iswprint (wint_t wc);
extern int iswpunct (wint_t wc);
extern int iswspace (wint_t wc);
extern int iswupper (wint_t wc);
extern int iswxdigit (wint_t wc);
extern wint_t towctrans (wint_t wc, wctrans_t type);
extern wint_t towlower (wint_t wc);
extern wint_t towupper (wint_t wc);
extern wctrans_t wctrans (const char *property);
extern wctype_t wctype (const char *property);

/* inline macros */
#define iswalnum(wc) (iswctype ((wc), wctype ("alnum")))
#define iswalpha(wc) (iswctype ((wc), wctype ("alpha")))
#define iswascii(wc) ((wc) >= 0 && (wc) <= 0x7f)
#define iswcntrl(wc) (iswctype ((wc), wctype ("cntrl")))
#define iswdigit(wc) (iswctype ((wc), wctype ("digit")))
#define iswgraph(wc) (iswctype ((wc), wctype ("graph")))
#define iswlower(wc) (iswctype ((wc), wctype ("lower")))
#define iswprint(wc) (iswctype ((wc), wctype ("print")))
#define iswpunct(wc) (iswctype ((wc), wctype ("punct")))
#define iswspace(wc) (iswctype ((wc), wctype ("space")))
#define iswupper(wc) (iswctype ((wc), wctype ("upper")))
#define iswxdigit(wc) (iswctype ((wc), wctype ("xdigit")))
#define towlower(wc) (towctrans ((wc), wctrans ("tolower")))
#define towupper(wc) (towctrans ((wc), wctrans ("toupper")))

/* follows japanese specification */
extern int iswhira (wint_t wc);
extern int iswkata (wint_t wc);
extern wint_t towhira (wint_t wc);
extern wint_t towkata (wint_t wc);
#define iswhira(wc) (iswctype ((wc), wctype ("hiragana")))
#define iswkata(wc) (iswctype ((wc), wctype ("katakana")))
#define towhira(wc) (towctrans ((wc), wctrans ("tohiragana")))
#define towkata(wc) (towctrans ((wc), wctrans ("tokatakana")))

#ifdef __cplusplus
}
#endif

#endif /* !__wctype_h__ */
