/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: _unitosj.c,v 1.3 1996/10/25 14:04:00 jack Exp $ */

#include <limits.h>
#include <mbprvt.h>

unsigned short
(__unicode_to_sjis) (unsigned short unicode)
{
#if (USHRT_MAX > 0xffff)
  /* check array size */
  if (unicode > 0xffff)
    return _MBC_ERROR_SJIS;
#endif

  /* check mapping table */
  if (__unicode_to_sjis_mapping == NULL)
    __mbmake_sjis_mapping_table ();

  /* convert to sjis */
  return __unicode_to_sjis_mapping[unicode];
}

unsigned short
(__string_unicode_to_sjis) (unsigned short *usp)
{
  unsigned short unicode;

  /* get unicode value */
  unicode = *usp;

#if (USHRT_MAX > 0xffff)
  /* check array size */
  if (unicode > 0xffff)
    return _MBC_ERROR_SJIS;
#endif

  /* check mapping table */
  if (__unicode_to_sjis_mapping == NULL)
    __mbmake_sjis_mapping_table ();

  /* convert to sjis */
  return __unicode_to_sjis_mapping[unicode];
}
