// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

// This file is contributed by
// Markus F.X.J. Oberhumer <markus.oberhumer@jk.uni-linz.ac.at>

#if defined(__MSDOS__) && defined(__DJGPP__) && (__DJGPP__ >= 2)

#include "arch.H"
#include <float.h>

static unsigned fpu_control_word = 0xffffffff;

// see i486-unknown-linux.cc for documentation

void
setup_fpu()
{
    fpu_control_word = _control87(
//	         RC_UP           // Round up always
	         RC_NEAR         // Round to nearest or even
	       | PC_24           // Use single precision internally
	       | EM_INVALID      // Ignore invalid instructions
	       | EM_DENORMAL     // Ignore denormalized operations
	       | EM_ZERODIVIDE   // Ignore divide by zero
	       | EM_INEXACT      // Ignore precision errors (?)
	       | EM_OVERFLOW     // Ignore overflow
	       | EM_UNDERFLOW    // Ignore underflow
	       , 
	         MCW_RC          // rounding control
	       | MCW_PC          // precision control
	       | MCW_EM          // exception masks
	       );
}

void
restore_fpu()
{
    if (fpu_control_word != 0xffffffff)
        _control87(fpu_control_word, MCW_RC | MCW_PC | MCW_EM | MCW_IC);
}

#endif /* defined(__MSDOS__) && defined(__DJGPP__) && (__DJGPP__ >= 2) */

