// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.


#include "VpNew.H"
#include <Lib3d/Texture.H>
#include <Lib3d/ColourRamp.H>
#include <math.h>

class Vp8 : public VpNew
{
public:
    const char *getName() const { return "Vp8"; }
    Colour getColour( uint r, uint g, uint b );
    void drawColourSpace() {}

protected:
    virtual void doTextureTriangleZb( edge_major_texture&, 
				      edge_minor_step &,
				      edge_minor_step &,
				      const Texture & );

    virtual void doFlatTriangleZb( edge_major_flat&, 
				   edge_minor&,
				   edge_minor&,
				   Colour );

    virtual void doSmoothTriangleZb( edge_major_smooth&, 
				     edge_minor_step&,
				     edge_minor_step&,
				     const ColourRamp & );

    virtual void lineZb( const DeviceVector &, 
			 const DeviceVector &, 
			 Colour );

    void initializeColours();

protected:
    Viewport *clone( Device *device );
    ~Vp8();
    Vp8( Exemplar e ) : VpNew( e, 100 ) {}
    Vp8( Device * );


protected:
    Colour *colourTable;
    static Vp8 *advertisement;
};

#define CLASS Vp8
#define PIXELTYPE uchar
#include "VpGeneric.cc"

Vp8::Vp8( Device *device )
    : VpNew( device ),
      colourTable(0)
{
}

Vp8::~Vp8()
{
    delete colourTable;
}

Viewport *
Vp8::clone( Device *device ) 
{ 
    return (device->getDepth() == 8) ? new Vp8( device ) : 0;
}

void
Vp8::initializeColours()
{
    colourTable = new Colour[4096];
    for(int i = 0 ; i < 4096 ; i++) {
	colourTable[i] = 0xff00ff00; // some impossible value.
    }
    getColour(0,0,0);	        
}

Colour
Vp8::getColour( uint r, uint g, uint b )
{
    if (!colourTable) initializeColours();

    Colour *colour = &colourTable[ ((r&0xf0) << 4)  
				 | ((g&0xf0))
				 | ((b&0xf0) >> 4)];

    if (*colour == 0xff00ff00) {
	*colour =  device->allocateColour(((r & 0xf0) << 8),
					  ((g & 0xf0) << 8),
					  ((b & 0xf0) << 8));
    }

    return *colour;
}














