// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#ifndef XDeviceClass
#define XDeviceClass

#include <Lib3d/Device.H>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

class XDevice : public Device
{
public:
    ~XDevice();
    
    uint allocateColour( uint red, uint green, uint blue );
    void notifyResize();

    void setSyncBehaviour(bool b);

    void processPendingEvents();
    void enableMouseCapability();
    void enableKeyboardCapability();
    void disableMouseCapability();
    void disableKeyboardCapability();

    static XDevice *create( Display *, Window, uint flags = 0 );

    
protected:
    XDevice( uint width, uint height, uint depth );
    XDevice( Display *, Window );
    XDevice( Exemplar );

    static void registerChildClass( XDevice *examplar );
    virtual XDevice *clone( Display *, Window ) = 0;

    bool initialize();

protected:
    bool initialized;
    Display *display;
    XColor *colours;
    Colormap colourMap;   
    int screenNr;
    Screen *screen;
    Window window;
    Visual *visual;
    GC gc;
    int lastX, lastY;		// previous mouse coords.
    bool syncOnSwaps;


private:
    static PointerArray<XDevice> *children;
};

#endif








