// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

// PostScript level 2 device driver.
// This file is contributed by Michael Ohme <mohme@informatik.uni-leipzig.de>

#ifndef PsDeviceHeader
#define PsDeviceHeader

#include <Lib3d/Devices/FileDevice.H>

// Direct access to the postscript file output device.  
//
// Include this file only if your application requires postscript
// specifically.  For general file output, use the FileDevice
// interface which is designed to support interactive selection of
// output file type.

class PsDevice : public FileDevice
{
public:
    PsDevice( Exemplar e );
    PsDevice( uint width, uint height, uint depth );
    ~PsDevice();

    const char *getName() const { return "PsDevice"; }
    const char *getFileType() const { return "Postscript Level 2"; }
    const char *getFileGlob() const { return "*.eps"; }

    bool initialize() { return true; }
    bool openFile(const char *f);
    void closeFile();
    void swapBuffers();

    uint allocateColour( uint red, uint green, uint blue );

protected:
    FileDevice *cloneFileDevice( uint width, uint height, uint depth );

private:
    FILE *out_dat;
    uint nr_pict;
    inline void write_char_hex(uchar c);
};

#endif
