/****************************************************************************/
/* VOCAB                                                                    */
/*--------------------------------------------------------------------------*/
/* JPTui vocabulary functions                                               */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre 					    */
/* Cr le    : 08/07/96                                                    */
/****************************************************************************/

#include <stdlib.h>


#include "Errors.h"
#include "JPData.h"
#include "Strings.h"

#include "Vocab.h"

static TLanguage s_language=NONE;


typedef struct vocab_node
{
  int		     number;
  char               *string;
  struct vocab_node  *next;
} TVocabNode,*PVocabNode;

static PVocabNode s_vocabulary[10]={NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};


TLanguage GetLanguage()
{
  return(s_language);
}

void FreeVocabulary()
{
  register int i;

  PVocabNode node,
	     next_node;

  for (i=0;i<=9;i++)
    {
      node=s_vocabulary[i];

      while (node!=NULL)
	{
	  delete [](node->string);
	  next_node=node->next;
	  delete node;
	  node=next_node;
	}

      s_vocabulary[i]=NULL;
    }
}

static bool LoadVocabularyFile(char *file_name)
{
  char *vocabulary;
  long length;

  bool ok;
  long line_length;
  char *ptr,*end_ptr;
  char *end_of_line_ptr;

  int  i;

  PVocabNode new_node;

  char *coma_ptr;
  long number;

  char *string;

  PVocabNode node;

  LoadDataFile(file_name,vocabulary,length);

  if (vocabulary==NULL)
    return false;

  // Analyse du fichier de vocabulaire

  ptr=vocabulary;
  ok=true;

  while (length>0)
    {
      end_of_line_ptr=(char *)memchr(ptr,'\r',(size_t)length);
      if (end_of_line_ptr==NULL)
	#ifdef __TCPLUSPLUS__
	end_of_line_ptr=ptr+(unsigned)length-1;
	#else
	end_of_line_ptr=ptr+length-1;
	#endif
      else
	end_of_line_ptr--;

      line_length=end_of_line_ptr-ptr+1;

      length-=(line_length+2);

      end_ptr=end_of_line_ptr;
      while (((*end_ptr)==' ') && (end_ptr>=ptr))
	end_ptr--;
      if (end_ptr>=ptr)   // Ligne non vide
	{
	  if ((*ptr)!=';') // Ligne commenant par ';' = commentaire
	    {
	      coma_ptr=(char *)memchr(ptr,',',(size_t)line_length);
	      if (coma_ptr==NULL)
		{
		  ok=false;
		  break;
		}

	      (*coma_ptr)=0;
	      if (!StringToLong(ptr,number))
		{
		  ok=false;
		  break;
		}

	      line_length-=(coma_ptr-ptr+1);
	      if (line_length<=0)
		{
		  ok=false;
		  break;
		}

	      ptr=(char *)memchr(coma_ptr+1,'\"',(size_t)line_length);
	      if (ptr==NULL)
		{
		  ok=false;
		  break;
		}

	      end_ptr=end_of_line_ptr;
	      while ((*end_ptr)!='\"')
		end_ptr--;

	      end_ptr--;
	      ptr++;

	      line_length=end_ptr-ptr+1;
	      if (line_length<0)
		{
		  ok=false;
		  break;
		}

	      #ifdef __TCPLUSPLUS__
	      string=new char [(unsigned)(line_length+1)];
	      #else
	      string=new char [line_length+1];
	      #endif

	      memcpy(string,ptr,(size_t)line_length);
	      #ifdef __TCPLUSPLUS__
	      string[(unsigned)line_length]=0;
	      #else
	      string[line_length]=0;
	      #endif

	      // Remplace les caractres ^ par des \n

	      ptr=string;
	      while ((ptr=strchr(ptr,'^'))!=NULL)
		(*ptr++)='\n';

	      i=(int)(number%10);

              // Does this number already exists ?

              node=s_vocabulary[i];

              while (node!=NULL)
                {
                  if (node->number==number)
	            return false;
                  node=node->next;
                }

              // Adds the new string

	      new_node=new TVocabNode;
	      new_node->number=(int)number;
	      new_node->string=string;
	      new_node->next=s_vocabulary[i];
	      s_vocabulary[i]=new_node;
	    }
	}

      // Ligne suivante

      ptr=end_of_line_ptr+3;
    }

  // Termin

  delete[] vocabulary;

  return(ok);
}

bool LoadVocabulary(TLanguage language)
{
  bool ok;

  static bool s_recurse=false;

  TLanguage old_language=s_language;

  char data_file1[13]="JPVOCAB.";
  char data_file2[13]="VOCAB.";
  char *suffix;
  char *suffix_tab[]={"ENG","FRE","GER","ITA","SPA","DUT","GRK"};


  if (language==s_language)
    return true;

  if ((language>=FIRST_LANGUAGE) && (language<=LAST_LANGUAGE))
    suffix=suffix_tab[language-FIRST_LANGUAGE];
  else
    return false;

  s_language=language;

  strcat(data_file1,suffix);
  strcat(data_file2,suffix);

  FreeVocabulary();

  ok=LoadVocabularyFile(data_file1);
  if (ok)
    ok=LoadVocabularyFile(data_file2);

  if (!ok)
    {
      FreeVocabulary();

      if (s_recurse)
	return false;

      if (old_language!=NONE)
	{
	  s_recurse=true;
	  if (!LoadVocabulary(old_language))
	    FatalError(GetInvalidDataFileMessage());
	  s_recurse=false;
	}
      return false;
    }

  if (!ok)
    {
      FreeVocabulary();
      if (!s_recurse)
	{
	  s_recurse=true;
	  if (!LoadVocabulary(old_language))
	    FatalError(GetInvalidDataFileMessage());
	  s_recurse=false;
	}
    }

  return(ok);
}

const char *GetString(int string_number)
{
  PVocabNode node;
  int i=string_number%10;

  node=s_vocabulary[i];

  while (node!=NULL)
    {
      if (node->number==string_number)
	return(node->string);
      node=node->next;
    }

  return("(?)");
}
