/****************************************************************************/
/* TLISTBOX                                                                 */
/*--------------------------------------------------------------------------*/
/* Objet TListBox (liste avec ascenseur)                                    */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 02/02/95                                                    */
/****************************************************************************/

#include <conio.h>

#include "Const.h"
#include "Debug.h"

#include "JPAppli.h"

#include "Screen.h"
#include "SpChars.h"
#include "Strings.h"

#include "TScrBar.h"
#include "TWindow.h"

#include "TListBox.h"

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************************************************************************/
/* Constructeur                                                             */
/*--------------------------------------------------------------------------*/
/* parent           : Objet auquel appartient l'objet                       */
/* rel_x, rel_y  : Coordonnes de l'objet p/r au groupe                     */
/* width,height  : Dimensions de l'objet                                    */
/* caption       : Lgende de l'objet (hot-key prcde de ~)               */
/* items         : Elments de la liste                                     */
/* sorted        : Indique si les lments ajouts  la liste sont tris ou */
/*                 non                                                      */
/* enabled       : ENABLED si le bouton est activable (DISABLED sinon)      */
/****************************************************************************/

TListBox::TListBox(PObject parent,
                   int rel_x,int rel_y,
                   int width,int height,
	           const char *caption,
		   const TListItem items[],
		   bool sorted,
		   bool enabled)
	 :TSimpleList(parent,
		      OBJ_LIST_BOX,
		      rel_x,rel_y,
		      width,height,
		      parent->m_get_background(),
		      caption,
		      1,((caption[0]==0)?0:1),
		      width-4,height-((caption[0]==0)?0:1),
		      sorted,
		      LI_DISABLED|LI_CHECKED|LI_TOGGLE, // Attributs autoriss
		      true,  // always one item selected
		      false, // item hotkey disabled,
		      true,  // scroll bar
		      width-2,
		      ((caption[0]==0)?0:1),
		      height-((caption[0]==0)?0:1),
		      enabled)
{
  // Ajout des lments

  if (items!=NULL)
    m_add_items(items);
}

/****************************************************************************/
/* Destructeur                                                              */
/*--------------------------------------------------------------------------*/
/****************************************************************************/

TListBox::~TListBox()
{
}

/*ͻ*/
/*                            METHODES PRIVEES                            */
/*ͼ*/

/****************************************************************************/
/* m_display                                                                */
/*--------------------------------------------------------------------------*/
/* Affichage de l'objet                                                     */
/****************************************************************************/

void TListBox::m_display()
{
  int x1,x2,y1,
      y2;
  char char_left;

  register int i;

  if (!f_open)
    return;

  x1=m_get_x_in_window();
  x2=x1+f_width-3;
  y1=m_get_y_in_window();
  y2=y1+f_height-1;

  // Barre du haut si pas de titre

  f_window->m_set_normal_attr(f_parent->m_get_background());

  if (f_caption[0]==0)
    {
      f_window->m_gotoxy(x1,y1-1);
      f_window->m_putch(SPECIAL_CHAR(SCH_LISTBOX_UP_LEFT));
      f_window->m_putnch(f_width-2,SPECIAL_CHAR(SCH_LISTBOX_UP));
      f_window->m_putch(SPECIAL_CHAR(SCH_LISTBOX_UP_RIGHT));
    }

  // Barre du bas

  f_window->m_gotoxy(x1,y2+1);
  f_window->m_putch(SPECIAL_CHAR(SCH_LISTBOX_BOTTOM_LEFT));
  f_window->m_putnch(f_width-2,SPECIAL_CHAR(SCH_LISTBOX_BOTTOM));
  f_window->m_putch(SPECIAL_CHAR(SCH_LISTBOX_BOTTOM_RIGHT));

  // Barre de gauche
  // Colonne d'espace  droite (hors liste)

  char_left=SPECIAL_CHAR(SCH_LISTBOX_LEFT);
  f_window->m_set_normal_attr(f_background);
  for (i=y1+((f_caption[0]==0)?0:1);i<=y2;i++)
    {
      f_window->m_gotoxy(x1,i);
      f_window->m_putch(char_left);
      f_window->m_gotoxy(x2,i);
      f_window->m_putch(' ');
    };

  // Affichage du reste

  TSimpleList::m_display();
}

/****************************************************************************/
/* m_display_focus_depending_part                                           */
/*--------------------------------------------------------------------------*/
/* Affichage de la partie de l'objet dont l'aspect dpend du focus          */
/****************************************************************************/

void TListBox::m_display_focus_depending_part()
{
  m_display_caption();
  TSimpleList::m_display_focus_depending_part();
}

/****************************************************************************/
/* m_display_caption                                                        */
/*--------------------------------------------------------------------------*/
/* Affichage de la lgende de l'objet                                       */
/****************************************************************************/

void TListBox::m_display_caption()
{
  if (!f_open)
    return;

  // S'il y a un titre

  if (f_caption[0]!=0)
    {
      f_window->m_gotoxy(m_get_x_in_window(),m_get_y_in_window());

      if ((f_focused) && (f_window->m_is_active()))
	f_window->m_set_bright_attr(WHITE);
      else
	f_window->m_set_normal_attr(WHITE);

      f_window->m_put_caption(f_caption,
		              f_enabled,
		              f_width,
			      CENTERED_LEFT);
    }

  // Sans titre : rien  changer

}


/****************************************************************************/
/* m_key_pressed_event                                                      */
/*--------------------------------------------------------------------------*/
/* L'utilisateur a appuy sur une touche qui est propose  l'objet         */
/* (qui est activable).                                                     */
/* Retourne true si l'objet est intress par cette touche.                 */
/****************************************************************************/

bool TListBox::m_key_pressed_event(TKey key)
{
  if (TSimpleList::m_key_pressed_event(key))
    return true;

  if (!f_focused)
    return false;

  if (key.character==SPACE)
    {
      if (f_selected_item_index!=0)
	{
	  // Elment de type TOGGLE ?

	  if (   (m_item_attribute_is_set(f_selected_item_index,LI_TOGGLE))
	      && (m_item_is_enabled(f_selected_item_index)))
	    {
	      if (!m_item_is_checked(f_selected_item_index))
		m_check_item(f_selected_item_index);
	      else
		m_uncheck_item(f_selected_item_index);
	    }
	}
      return true;
    }

  return false;
}

/****************************************************************************/
/* m_item_dbl_clicked_callback                                              */
/*--------------------------------------------------------------------------*/
/* Fonction appele quand on double-clic sur un lment de la liste.        */
/****************************************************************************/

void TListBox::m_item_dbl_clicked_callback(int index)
{
  DEBUG_TEST(index!=0);

  // Elment de type TOGGLE ?

  if (   (m_item_attribute_is_set(index,LI_TOGGLE))
      && (m_item_is_enabled(f_selected_item_index)))
    {
      if (!m_item_is_checked(f_selected_item_index))
	m_check_item(f_selected_item_index);
      else
	m_uncheck_item(f_selected_item_index);
    }

  TSimpleList::m_item_dbl_clicked_callback(index);
}
