#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "Types.h"

#define NB_POINTERS 2

typedef unsigned char        u_char;


FILE *CursorFile=NULL;



// Curseurs 9x16

u_char pointer9_16[NB_POINTERS][34]=

			{ { 1,1,   // hot spot

			    0x00,       // 
			    0x40,       // 
			    0x60,       // 
			    0x70,       // 
			    0x78,       // 
			    0x7C,       // 
			    0x7E,	// 
			    0x7E,       // 
			    0x78,       // 
			    0x4C,       // 
			    0x0C,	// 
			    0x04,       // 
			    0x06,       // 
			    0x06,       // 
			    0x00,	// 
			    0x00,       // 

			    0xC0,       //       // 
			    0xE0,       //       // 
			    0xF0,       //       // 
			    0xF8,       //       // 
			    0xFC,       //       // 
			    0xFE,       //       // 
			    0xFF,       //       // 
			    0xFF,       //       // 
			    0xFE,       //       // 
			    0xFE,       //       // 
			    0xDE,       //       //  
			    0x0E,       //       //     
			    0x0F,       //       //     
			    0x0F,       //       //     
			    0x06,       //       //      
			    0x00 },     //       //

			  { 3,7,   // hot spot

			    0x00,       // 
			    0xFE,       // 
			    0x82,       // 
			    0x82,       // 
			    0xAA,       // 
			    0x54,       // 
			    0x28,       // 
			    0x10,	// 
			    0x10,	// 
			    0x28,       // 
			    0x44,       // 
			    0x92,       // 
			    0xAA,       // 
			    0xD6,       // 
			    0xFE,       // 
			    0x00,       // 

			    0xFF,       //       // ........
			    0xFF,       //       // .
			    0xFF,       //       // ......
			    0xFF,       //       // ......
			    0xFF,       //       // 
			    0xFE,       // .      // 
			    0x7C,       // ...      //  
			    0x38,       // .....      //   
			    0x38,       // .....      //   
			    0x7C,       // ...      //  
			    0xFE,       // .      // 
			    0xFF,       //       // 
			    0xFF,       //       // 
			    0xFF,       //       // 
			    0xFF,       //       // 
			    0xFF }      //       // ........
		       };

// Curseurs 8x14

u_char pointer8_14[NB_POINTERS][30]=

			{ { 1,1,   // hot spot

			    0x00,       // 
			    0x40,       // 
			    0x60,       // 
			    0x70,       // 
			    0x78,       // 
			    0x7C,       // 
			    0x7E,	// 
			    0x7E,       // 
			    0x78,       // 
			    0x4C,       // 
			    0x0C,	// 
			    0x06,       // 
			    0x06,       // 
			    0x00,       // 

			    0xC0,       //       // 
			    0xE0,       //       // 
			    0xF0,       //       // 
			    0xF8,       //       // 
			    0xFC,       //       // 
			    0xFE,       //       // 
			    0xFF,       //       // 
			    0xFF,       //       // 
			    0xFE,       //       // 
			    0xFE,       //       // 
			    0xDE,       //       //  
			    0x0F,       //       //     
			    0x0F,       //       //     
			    0x06 },     //       //      


			  { 3,6,   // hot spot

			    0x00,       // 
			    0xFE,       // 
			    0x82,       // 
			    0xAA,       // 
			    0x54,       // 
			    0x28,       // 
			    0x10,	// 
			    0x10,	// 
			    0x28,       // 
			    0x44,       // 
			    0x92,       // 
			    0xAA,       // 
			    0xFE,       // 
			    0x00,       // 

			    0xFF,       //       // ........
			    0xFF,       //       // .
			    0xFF,       //       // ......
			    0xFF,       //       // 
			    0xFE,       // .      // 
			    0x7C,       // ...      //  
			    0x38,       // .....      //   
			    0x38,       // .....      //   
			    0x7C,       // ...      //  
			    0xFE,       // .      // 
			    0xFF,       //       // 
			    0xFF,       //       // 
			    0xFF,       //       // 
			    0xFF }      //       // ........

		       };
// Curseurs 8x8

u_char pointer8_8[NB_POINTERS][18]=

			{ { 1,1,   // hot spot

			    0x00,       // 
			    0x60,       // 
			    0x78,       // 
			    0x7E,	// 
			    0x78,       // 
			    0x4C,	// 
			    0x06,       // 
			    0x00,	// 

			    0xE0,       //       // 
			    0xF8,       //       // 
			    0xFE,       //       // 
			    0xFF,       //       // 
			    0xFE,       //       // 
			    0xFE,       //       // 
			    0xCF,       //       //   
			    0x06 },     //       //      


			  { 3,3,   // hot spot

			    0x00,       // 
			    0x7E,       // 
			    0x42,       // 
			    0x24,       // 
			    0x3C,       // 
			    0x7E,       // 
			    0x7E,       // 
			    0x00,       // 

			    0xFF,       //       // 
			    0xFF,       //       // 
			    0xFF,       //       // 
			    0x7E,       // .      //  
			    0x7E,       // .      //  
			    0xFF,       //       // 
			    0xFF,       //       // 
			    0xFF }      //       // 
		       };

void CloseFiles()
{
  if (CursorFile!=NULL)
    fclose(CursorFile);
}


void MakeCursors()
{
  u_char *buffer;
  int size;
  char *filename;
  register int i;

  for (i=1;i<=4;i++)
    {
      switch (i)
	{
	  case 1 : filename="JP9x16.PTR";
		   buffer=&(pointer9_16[0][0]);
		   size=34;   // 2+(2*16)
		   break;
	  case 2 : filename="JP8x16.PTR";
		   buffer=&(pointer9_16[0][0]);
		   size=34;   // 2+(2*16)
		   break;
	  case 3 : filename="JP8x14.PTR";
		   buffer=&(pointer8_14[0][0]);
		   size=30;   // 2+(2*14)
		   break;
	  case 4 : filename="JP8x8.PTR";
		   buffer=&(pointer8_8[0][0]);
		   size=18;   // 2+(2*8)
		   break;
	}

      CursorFile=fopen(filename,"wb");
      if (CursorFile==NULL)
	{
	  cerr << "\nImpossible d'ouvrir le fichier " << filename << "\n\n";
	  exit(-1);
	}

      if (fwrite(buffer, size, NB_POINTERS, CursorFile)!=NB_POINTERS)
	{
	  cerr << "\nErreur pendant l'criture du fichier " << filename << "\n\n";
	  exit(-1);
	}

      fclose(CursorFile);
      cout << "Fichier " << filename << " cr...\n";
    }

}

void main(int argc,char *argv[])
{
  bool help_wanted=false;
  register int i;

  cout << "\n\nJP_PTR : Cre les fichiers contenant les pointeurs\n";
  cout <<     "         souris de la librairie JPTUI.\n";
  cout <<     "         Jeepy Software - Juillet 1996\n\n";

  // Aide demande explicitement

  for (i=1;i<argc;i++)
    {
      if (!strcmp(argv[i],"/?"))
	help_wanted=true;
    }

  if ((help_wanted) || (argc!=1))
    {
      cout << "Syntaxe : [/?]\n\n";
      return;
    }

  MakeCursors();
}
