#ifndef JONIPX_H

#define JONIPX_H

#include <dos.h> /* For delay */


#define MY_SOCKET 0x869C /* Socket used by these routines */

#define MAX_PACKETS_IN_BUFFER 100

/* Amount we delay between sending packets */
#define IPX_DELAY                        3

#define WAITING_FOR_NODES_PACKET         10
#define PLAYER_NUMBER_ASSIGNMENT_PACKET  11
#define HERE_I_AM_PACKET                 12
#define GAME_INIT_PACKET                 13
#define BIG_ASS_GAME_INFO_PACKET         14

#define READY_PACKET                     15  /* Indicates we are ready to move on */

#define SERVER_INPUT_TABLE_PACKET        16
#define CLIENT_INPUT_TABLE_PACKET        17
#define WAITING_FOR_INPUT_TABLE_PACKET   18

#define TEAM_REQUEST_PACKET              19
#define TEAM_ASSIGNMENT_PACKET           20
#define WAITING_FOR_TEAM_REQUEST_PACKET  21


#define PLAYER_INFO_PACKET               22
#define CYLINDER_FILENAME_PACKET         23

#define TERMINATE_IPX_CONNECTION_PACKET  24
#define END_IPX_GAME_PACKET              25


#define TRUE  1
#define FALSE 0


typedef unsigned char boolean;


typedef unsigned char net_type[4];
typedef unsigned char node_address_type[6];

typedef char string_type[80];

typedef unsigned short address_type[2];

typedef struct 
    {                                                        
     net_type          net           __attribute__((packed));  /* Network address */
     node_address_type node_address  __attribute__((packed));  /* Node address */
     unsigned short    socket        __attribute__((packed));  /* Big endian socket number */
    } net_address_type;

typedef struct
    {
     net_type           net          __attribute__((packed)); /* My network address */
     node_address_type  node_address __attribute__((packed)); /* My node address */
    } local_address_type;

typedef struct
    {
     address_type      link              __attribute__((packed)); /* Pointer to next ECB */
     unsigned long     ESR               __attribute__((packed)); /* Event service routine 00000000h if none */
     unsigned char     in_use            __attribute__((packed)); /* In use flag */
     unsigned char     complete          __attribute__((packed)); /* Completing flag */
     unsigned short    socket            __attribute__((packed)); /* Big endian socket number */
     unsigned char     IPX_work[4]       __attribute__((packed)); /* IPX work space */
     unsigned char     D_work[12]        __attribute__((packed)); /* Driver work space */
     node_address_type immediate_address __attribute__((packed)); /* Immediate local node address */
     unsigned short    fragment_count    __attribute__((packed)); /* Fragment count */
     unsigned long     fragment_data     __attribute__((packed)); /* Pointer to data fragment */
     unsigned short    fragment_size     __attribute__((packed)); /* Size of data fragment */
    } ECB_type;

typedef struct
    {
     unsigned short   checksum          __attribute__((packed));   /* Big endian checksum */
     unsigned short   length            __attribute__((packed));   /* Big endian length in bytes */
     unsigned char    transport_control __attribute__((packed));   /* Transport control */
     unsigned char    packet_type       __attribute__((packed));   /* Packet type */
     net_address_type destination       __attribute__((packed));   /* Destination network address */
     net_address_type source            __attribute__((packed));   /* Source network address */
    } IPX_header_type;


/* Used internally */
typedef struct
    {
     ECB_type        ecb         __attribute__((packed));
     IPX_header_type ipx_header  __attribute__((packed));
     string_type     string      __attribute__((packed));
    } packet_type;


/* Generally the user will use this for packets */
typedef struct
    {
     string_type       string;
     node_address_type source_node;
    } game_packet_type;



/* This is used by the pop_packet routines...packets are placed here
   by a callback whenever a packet is recieved by the driver */
typedef struct
    {
     game_packet_type    packets[MAX_PACKETS_IN_BUFFER]; /* Array of packets */
     unsigned short      buffer_start; /* The last packet we read */
     unsigned short      buffer_pos;   /* The most recent packet */
    } packet_buffer_type;




int Compare_Nodes( node_address_type node_one, node_address_type node_two );
unsigned short Endian_Swap( unsigned short old_short );
int IPX_Open_Socket( unsigned char longetivity, unsigned short *socket_number );
void IPX_Close_Socket( unsigned short *socket_number );
void Get_Local_Address();
void IPX_Send_Packet( ECB_type *ecb );
int IPX_Listen_For_Packet( ECB_type *ecb );
void Im_Idle( void );
void Init_Send_Packet( ECB_type *ecb, IPX_header_type *ipx_header, 
                       unsigned short size, unsigned short sock );
void Init_Recieve_Packet( ECB_type *ecb, IPX_header_type *ipx_header, 
                          unsigned short size, unsigned short sock );
int Init_IPX( void );
int Jon_Get_Packet( string_type string, node_address_type source_node );


/* These are the functions you will most likely use */

int Init_Jonipx( void );
void Close_Jonipx( void );
int Packet_Ready( void );
int Pop_Packet( game_packet_type *packet );
int Jon_Send_Packet( string_type string, int length, node_address_type dest_node );

/*                                                  */


#endif


