//This computes Pade Approximants to sqr((1+2x)/(1+x)) and evaluates them
//at infinity (see Baker,Essentials of Pade Approximants, p.5). The number
//of significant figures (32) and maximum order of approximation (19) could
//be increased easily.

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int precision = 8;               
const int zmaxsize=40;
const int cmaxsize=0;

#include "genprec.h"
#include "cgenprec.h"
#include "apps.h"

int n;
int nmax;

realmp p;
realmp a[zmaxsizepad];
realmp b[zmaxsizepad];
realmp c[zmaxsizepad];
pademp d;
realmp dnum[zmaxsizepad];
realmp dden[zmaxsizepad];

int main()
  {int i;
   zsupe();                 //run this if e is needed
   zsuplogsp();             //run this if log base e of 10 is needed
   n=38;
                           //compute series for sqrt[(1+2x)/(1+x)]
   a[0]=1;         //a=1 + 2x,b=1+x
   a[1]=2;
   b[0]=1;
   b[1]=1;
   for (i=2;i<n+1;i++)       //remaining terms in a,b are zero
     {a[i]=0;
      b[i]=0;}            //end set up
   p=-1;
   c<stonth(n,b,p);
   c<smult(n,a,c);          //a*b^-1     //multiply series
   p=1;                                   //need < for series
   p=p/2;
   c<stonth(n,c,p);           //c^(1/2)
   for (i=1;i<n/2;i++)
     {cout<<i<<"/"<<i<<" Pade Approximant at infinity"<<'\n';
      d<padeapprox(i,i,c);
      dnum<extractnum(i,d);
      dden<extractden(i,d);
      printmp(dnum[i]/dden[i]);
      zmessage=" ";
      zbreak();
     }
   return 0;
  }
