/* DJGPPTSR, Nov 1995 Charles Sandmann (sandmann@clio.rice.edu)
   Updated Oct 2002.

   ABSOLULTELY NO WARRANTY.  May be redistributed or copied without restriction.

   An example of a DJGPP TSR.  This routine changes the video attribute of the
   character in the upper right of the screen once per tick (from protected
   mode).  The DPMI provider will be forced to stay resident after this image
   exits.  This code also shows an undocumented way to suppress the exception
   code loading to decrease the image footprint size.  Not optimal - you can
   do the same thing with a single GAS file with a much smaller image.  Left 
   as an exercise for the user.  Have fun!  */

#include <stdio.h>
#include <io.h>
#include <dpmi.h>
#include <crt0.h>
#include <sys/farptr.h>
#include <go32.h>
#include <pc.h>
#include "keep.h"

int _crt0_startup_flags = _CRT0_FLAG_LOCK_MEMORY;

#ifdef SMALL_IMAGE
int _stklen = 8192;			/* 32-bit stack size */
void __crt0_load_environment_file(char *_app_name) { return; }
void __crt0_setup_arguments(void) { return; }
char **__crt0_glob_function(char *_arg) { return 0; }

/* Start undocumented way to make exception handling disappear (v2.03) */
void _npxsetup(void) { return; }
int __emu387_load_hook;
short __djgpp_ds_alias;
void __djgpp_exception_setup(void) { return; }
int __djgpp_set_ctrl_c(int enable) { return 0; }
void abort(void) { __exit(-1); }
void _exit(int status) { __exit (status); }
/* End undocumented way to make exception handling disappear */
#endif

void int8(void)
{
  unsigned offset = ScreenPrimary+(2*79)+1;	/* Video attribute byte */
  _farsetsel(_dos_ds);
  _farnspokeb(offset,1+_farnspeekb(offset));
}

int main(void)
{
  _go32_dpmi_seginfo pmint;
   
  pmint.pm_selector = _my_cs();
  pmint.pm_offset = (unsigned)&int8;
  _go32_dpmi_chain_protected_mode_interrupt_vector(8, &pmint);
  _write(2,"Installing DJGPP TSR\r\n",22);
#ifndef SMALL_IMAGE
  __djgpp_exception_toggle();		/* Only needed if exceptions linked */
  keep(0, 0);				/* Keep Transfer Buffer */
#else
  keep(0, 16);				/* Only keep PSP, don't save TB */
#endif
  return 0;
}
