/*  Example programs for BETATRON game library. 
 ** Copyright (C) 1997 Liouros Thanasis, liouros@hotmail.com
 **
 ** scroll.cc:  This file is part of the example programs for BETATRON game 
 **             library and can be used and/or distributed only under the terms 
 **             of the GNU General Public License. See doc/examples.txt for 
 **             details.
 */

#include "world.h"
#include "scroll.h"



static void scrollaction(TOscroll *o)
{
 TOworld  *w=o->owner;
 // if the 'guy' moves out of the window defined by hlimit and vlimit
 // then the scrolling will begin
 unsigned short hlimit = (unsigned short) (w->Xres*14L/100L);
 unsigned short vlimit = (unsigned short) (w->Yres*15L/100L);

 unsigned short hgoto = (unsigned short) (w->Xres*45L/100L);
 unsigned short vgoto = (unsigned short) (w->Yres*48L/100L);



  if (!o->xscroll)
  {
        if ( o->pguy->x < (w->x + hlimit) ) o->xscroll=-o->dxscroll;
   else if ( o->pguy->x > (w->x + w->Xres-hlimit) ) o->xscroll=o->dxscroll;
  }
  else
  {
    w->scrollR(o->xscroll);
    if (  (o->pguy->x <= w->x + w->Xres-hgoto) && (o->pguy->x >= w->x+hgoto) ) o->xscroll=0;
  }

  if (!o->yscroll)
  {
        if ( o->pguy->y < (w->y + vlimit) ) o->yscroll=-o->dyscroll;
   else if ( o->pguy->y > (w->y + w->Yres - vlimit) ) o->yscroll=o->dyscroll;
  }
  else
  {
    w->scrollD(o->yscroll);
    if (  (o->pguy->y <= w->y + w->Yres-vgoto) && (o->pguy->y >= w->y+vgoto) ) o->yscroll=0;
  }
}


void TOscroll::init(unsigned char id0, TOobject *pguy0, unsigned char dxs0, unsigned char dys0)
{
 TOobject::init(id0,0,0,1,1);  // put somewhere the object in the world
 nextaction=(TPaction) scrollaction;
 pguy=pguy0;
 xscroll=yscroll=0;
 dxscroll=dxs0;
 dyscroll=dys0;
}
